# 🌐 Website Base Projesi - Genel Kullanım Kılavuzu

Bu doküman, Website Base altyapısını kullanan tüm projeler için geliştirme, dağıtım ve güncelleme süreçlerini detaylı bir şekilde açıklamak amacıyla hazırlanmıştır. PHP 8.x, Composer, .env yapılandırması ve Canvas HTML teması ile uyumlu, modern, modüler ve güvenli bir yapı hedeflenmiştir.

---

## Başlangıç

1. `upload-me` klasörünün içindeki tüm dosyaları sunucunuzun kök dizinine (public_html veya www) FTP ile yükleyin, yükleme klasöründeki diğer tüm diğer dosyaları silin
2. Tarayıcıda `https://siteadresiniz.com/zip.php` adresine gidin
3. Bu işlem `source-files.zip` dosyasını otomatik olarak açar ve ardından `zip.php` kendini siler
4. Açılan ekrandan “Kuruluma Başla” butonuna tıklayın veya `install.php` adresine giderek kurulumu tamamlayın

---

## 📦 Teknolojik Bileşenler

- **PHP 8.x** ve **MySQL** uyumlu
- Composer ile bağımlılık yönetimi
- .env dosyası ile güvenli yapılandırma
- Canvas Theme (https://docs.semicolonweb.com/docs/getting-started)
- Admin panelde özel form yapıları ve CSS düzeni
- Özelleştirilebilir mod (dark-light) toggle sistemi
- Git ile versiyon kontrolüne uyumlu
- Otomatik uzaktan güncelleme sistemi (update-manager.php)

---

## 📁 Klasör Yapısı

```
/app/               → Yardımcı fonksiyonlar, versiyon
/config/            → Yapılandırma dosyaları (.env dahil)
/public/            → Erişilebilir tüm frontend dosyaları
/admin/controller/  → Admin sayfa kontrol dosyaları
/views/             → Sayfa şablonları (Canvas uyumlu)
/assets/            → CSS/JS/Image içerikleri
/vendor/            → Composer bağımlılıkları
```

---

## 🧩 Tema (Canvas) Uyum Kuralları

Canvas Theme kullanımı için dikkat edilmesi gerekenler:

- Tüm içerikler `#wrapper` içinde olmalı
- `.container` asla iç içe olmamalı (önce kapat, sonra aç)
- Alt sayfa başlıkları:
```php
$toolMainTitle = _('Başlık');
$toolSubTitle = _('Alt Başlık');
$menuItems = [['url' => '...', 'title' => '...']];
require view('static/toolbar');
```

- `toolbar.php` Canvas uyumlu breadcrumb yapısı içerir
- Alt sayfalar `page-title`, `container`, `breadcrumb` sınıflarına sadık kalmalı

---

## 🌗 Tema Modu Değiştirme (Dark/Light)

- Canvas’ın `body-scheme-toggle` özelliği kullanılır
- JavaScript ile cookie’ye tema kaydedilir (`theme = dark | light`)
- `theme-toggle.js` dosyası ile body sınıfı ve buton görünümü senkronize edilir
- Mod seçimi sayfa yenilense bile korunur

Buton örneği:
```html
<button class="btn btn-sm btn-dark body-scheme-toggle"
        data-bodyclass-toggle="dark"
        data-add-class="btn-warning"
        data-remove-class="btn-dark"
        data-add-html="<?=_('Light Mode')?>"
        data-remove-html="<?=_('Dark Mode')?>"><span class="visually-hidden">Dark Toggle</span></button>
```

---

## ⚙️ .env Yapılandırması

`.env.example` dosyasını çoğaltarak `.env` dosyasına çevirin:

```
DB_HOST=localhost
DB_NAME=veritabani
DB_USER=kullanici
DB_PASS=sifre
VERSION=1.0.0
```

---

## 🧑‍💻 Admin Panel Yapısı

- Header/Footer dahil etme: `admin_view()`
- Form yapıları: `.form .label`, `.form-content`, `ul > li`
- Ayarlar kartları: `.setting-card`, `.setting-item`, `.switch` (extra.css üzerinden stillenir)
- Ayarlar bölümleri: `admin/settings/general`, `admin/settings/maintenance` gibi ayrı dizinlere ayrılır
- Ayarlarda kullanılan yapı:
```php
<div class="setting-card">
  <h3>Ayar Başlığı</h3>
  <p>Açıklama</p>
  <input type="text" name="ayar" />
</div>
```

---

## 🔄 Güncelleme Sistemi (Remote)

Sistem uzaktan güncellenebilir altyapıya sahiptir:

- `app/version.php` → mevcut sürüm
- `update.json` → uzaktaki sunucudan gelen yeni sürüm bilgisi
- `update.php` → zip dosyasını indirip çıkarır, sürüm günceller

Detaylı kullanım için `update-readme.md` dosyasına bakınız.

---

## 🔐 Güvenlik

- Tüm hassas bilgiler `.env` içinde
- Admin yetkisi `Admin(5)` fonksiyonu ile kontrol edilir
- Kullanıcıya özel veriler hiçbir zaman frontend üzerinden ulaşılabilir olmamalı

---

## 📂 Versiyonlama ve Git

- Projeler Git ile versiyonlanabilir
- Core yapı başka projelere `git clone` edilerek çoğaltılabilir
- Güncellemeler `git pull` ile dağıtılabilir veya uzaktan `update.json` ile

---

## 🔤 Çoklu Dil (gettext)

- Sistem gettext uyumlu
- Kullanıcıya gösterilen her sabit metin şu şekilde yazılır:
```php
<?= _('Home') ?>
```

- `/translate` komutu ile dil dosyaları hazırlanabilir
- Çıktılar `.po` ve `.mo` formatında alınır (hem `en` hem `tr`)

---

## 🧪 Test / Dağıtım

- Yeni proje oluştururken:
  - Sadece gerekli klasör ve dosyalar zip’e eklenmeli
  - `uploads/`, `storage/`, `vendor/`, `.env` gibi şeyler hariç tutulmalı
- Başlangıç kurulumu için:
  - Veritabani kurulumu
  - `.env` yapılandırması
  - Varsayılan ayarların kontrolü
  - Admin panel erişimi testi

---

## 🗂 Kök Dizin Yapısı (Boacore - 1 Nisan 2025)

```
Boacore/
├── admin/
│   ├── controller/
│   │   ├── ajax/
│   │   └── *.php dosyaları
│   ├── public/
│   │   ├── images/
│   │   ├── sass/
│   │   ├── scripts/
│   │   ├── styles/
│   │   └── vendor/
│   └── view/
│       ├── static/
│       │   └── settings/
│       └── *.php dosyaları
│
├── app/
│   ├── classes/
│   │   ├── Admin/
│   │   ├── Blog/
│   │   ├── Database/
│   │   ├── Destek/
│   │   ├── Istatistik/
│   │   ├── Send/
│   │   └── Uyelik/
│   ├── controller/
│   │   ├── ajax/
│   │   ├── cron/
│   │   └── *.php dosyaları
│   ├── helper/
│   ├── view/
│   │   ├── boa-basic/
│   │   │   └── static/
│   │   │       └── *
│   ├── config.php
│   ├── init.php
│   ├── settings.php
│   ├── version.php
│
├── public/
│   ├── boa-basic/
│   │   ├── css/
│   │   ├── images/
│   │   ├── js/
│   │   └── style.css
│   └── uploads/
│
├── storage/
│   └── cache/
│       └── app_settings.php
│
├── languages/
│   └── tr_TR/
│       └── LC_MESSAGES/
│           ├── messages.po
│           └── messages.mo
│
├── composer.json
├── composer.lock
├── global.php
├── index.php
├── install.php
├── setup.sql
└── vendor/
```

---

Hazırlayan: **Özer**  
Proje: `website-base` – Genişletilebilir PHP Altyapısı  
Versiyon: 1.0.0
