function getUserTimezone() {
  const match = document.cookie.match(/(?:^|;\s*)user_timezone=([^;]+)/);
  return match ? decodeURIComponent(match[1]) : 'UTC';
}

document.addEventListener('DOMContentLoaded', function () {
  const timezone = getUserTimezone();

  document.querySelectorAll('.utc-time').forEach(el => {
    const utcDateStr = el.getAttribute('data-utc');
    if (utcDateStr) {
      const localTime = new Date(utcDateStr).toLocaleString('en-US', {
        timeZone: timezone,
        year: 'numeric',
        month: 'short',
        day: 'numeric',
        hour: '2-digit',
        minute: '2-digit',
      });
      el.textContent = localTime;
    }
  });
});
