document.addEventListener('DOMContentLoaded', function () {
	function setCookie(name, value, days) {
		var expires = "";
		if (days) {
			var date = new Date();
			date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
			expires = "; expires=" + date.toUTCString();
		}
		document.cookie = name + "=" + (value || "") + expires + "; path=/";
	}

	function getCookie(name) {
		var nameEQ = name + "=";
		var ca = document.cookie.split(';');
		for (var i = 0; i < ca.length; i++) {
			var c = ca[i];
			while (c.charAt(0) == ' ') c = c.substring(1, c.length);
			if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length, c.length);
		}
		return null;
	}

	// Sayfa yüklendiğinde: body'ye cookie'deki class'ı uygula
	const theme = getCookie("theme");
	if (theme === "dark") {
		document.body.classList.add("dark");
	} else {
		document.body.classList.remove("dark");
	}

	// Butona tıklanınca cookie'yi güncelle
	const toggleBtn = document.querySelector('.body-scheme-toggle');
	if (toggleBtn) {
		toggleBtn.addEventListener('click', function () {
			const isDark = document.body.classList.contains('dark');
			setCookie("theme", isDark ? "dark" : "light", 30);
		});
	}
});