jQuery(function() {
    jQuery('.component-datepicker.default').datepicker({
        autoclose: true,
        startDate: "today",
    });

    jQuery('.component-datepicker.today').datepicker({
        autoclose: true,
        startDate: "today",
        todayHighlight: true
    });

    jQuery('.component-datepicker.past-enabled').datepicker({
        autoclose: true,
    });

    jQuery('.component-datepicker.format').datepicker({
        autoclose: true,
        format: "dd-mm-yyyy",
    });

    jQuery('.component-datepicker.autoclose').datepicker();

    jQuery('.component-datepicker.disabled-week').datepicker({
        autoclose: true,
        daysOfWeekDisabled: "0"
    });

    jQuery('.component-datepicker.highlighted-week').datepicker({
        autoclose: true,
        daysOfWeekHighlighted: "0"
    });

    jQuery('.component-datepicker.mnth').datepicker({
        autoclose: true,
        minViewMode: 1,
        format: "mm/yy"
    });

    jQuery('.component-datepicker.multidate').datepicker({
        multidate: true,
        multidateSeparator: " , "
    });

    jQuery('.component-datepicker.input-daterange').datepicker({
        autoclose: true
    });

    jQuery('.component-datepicker.inline-calendar').datepicker();

    jQuery('.datetimepicker').datetimepicker({
        showClose: true
    });

    jQuery('.datetimepicker1').datetimepicker({
        format: 'LT',
        showClose: true
    });

    jQuery('.datetimepicker2').datetimepicker({
        inline: true,
        sideBySide: true
    });

    jQuery('.datetimepicker3,.datetimepicker4').datetimepicker();

    // .daterange1
    jQuery(".daterange1").daterangepicker({
        "buttonClasses": "button button-rounded button-mini m-0",
        "applyClass": "button-color",
        "cancelClass": "button-light"
    });

    // .daterange2
    jQuery(".daterange2").daterangepicker({
        "opens": "center",
        timePicker: true,
        timePickerIncrement: 30,
        locale: {
            format: 'MM/DD/YYYY h:mm A'
        },
        "buttonClasses": "button button-rounded button-mini m-0",
        "applyClass": "button-color",
        "cancelClass": "button-light"
    });

    // .daterange3
    jQuery(".daterange3").daterangepicker({
        singleDatePicker: true,
        showDropdowns: true
    },
    function(start, end, label) {
        var years = moment().diff(start, 'years');
        alert("You are " + years + " years old.");
    });

    // reportrange
    function cb(start, end) {
        jQuery(".reportrange span").html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
    }
    cb(moment().subtract(29, 'days'), moment());

    jQuery(".reportrange").daterangepicker({
        "buttonClasses": "button button-rounded button-mini m-0",
        "applyClass": "button-color",
        "cancelClass": "button-light",
        ranges: {
           'Today': [moment(), moment()],
           'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
           'Last 7 Days': [moment().subtract(6, 'days'), moment()],
           'Last 30 Days': [moment().subtract(29, 'days'), moment()],
           'This Month': [moment().startOf('month'), moment().endOf('month')],
           'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        }
    }, cb);

    // .daterange4
    jQuery(".daterange4").daterangepicker({
        autoUpdateInput: false,
        locale: {
            cancelLabel: 'Clear'
        },
        "buttonClasses": "button button-rounded button-mini m-0",
        "applyClass": "button-color",
        "cancelClass": "button-light"
    });

    jQuery(".daterange4").on('apply.daterangepicker', function(ev, picker) {
        jQuery(this).val(picker.startDate.format('MM/DD/YYYY') + ' - ' + picker.endDate.format('MM/DD/YYYY'));
    });

    jQuery(".daterange4").on('cancel.daterangepicker', function(ev, picker) {
        jQuery(this).val('');
    });

});