<?php
// Hatalari goster
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Eğer kurulum zaten yapıldıysa engelle
if (file_exists(__DIR__ . '/install.lock')) {
    die('Kurulum zaten tamamlanmış.');
}

// Hata mesajı kontrolü
$error = $_GET['error'] ?? null;

// Form gönderildiyse
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $dbHost = $_POST['db_host'] ?? '';
    $dbName = $_POST['db_name'] ?? '';
    $dbUser = $_POST['db_user'] ?? '';
    $dbPass = $_POST['db_pass'] ?? '';
    $siteUrl = $_POST['site_url'] ?? '';
    $adminEmail = $_POST['admin_email'] ?? '';
    $adminPassword = $_POST['admin_password'] ?? '';
    $smtpAddress = $_POST['smtp_address'] ?? '';
    $smtpPort = $_POST['smtp_port'] ?? '587';
    $smtpSecure = $_POST['smtp_secure'] ?? 'tls';
    $smtpEmail = $_POST['smtp_email'] ?? '';
    $smtpUsername = $_POST['smtp_username'] ?? '';
    $smtpPassword = $_POST['smtp_password'] ?? '';
    $recaptchaSite = $_POST['recaptcha_site'] ?? '';
    $recaptchaSecret = $_POST['recaptcha_secret'] ?? '';
    $googleTag = $_POST['google_tag'] ?? '';
    $globalSecret = bin2hex(random_bytes(32));

    if (!$dbHost || !$dbName || !$dbUser || !$siteUrl || !$adminEmail || !$adminPassword) {
        header('Location: install.php?error=Eksik bilgi girdiniz.');
        exit;
    }

    $editedSiteUrl = preg_replace('#^https?://#', '', $siteUrl);

    // .env içeriği oluştur
    $envContent = <<<ENV
BASE_URL=$siteUrl
SUBFOLDER=false

COOKIE_DOMAIN={$editedSiteUrl}
COOKIE_PATH=/
COOKIE_SECURE=true
COOKIE_HTTPONLY=true

VERI_DB_HOST=$dbHost
VERI_DB_NAME=$dbName
VERI_DB_USER=$dbUser
VERI_DB_PASS=$dbPass

GLOBAL_SECRET_KEY=$globalSecret

OPENAI_SECRET_KEY=

SMTP_ADDRESS=$smtpAddress
SMTP_PORT=$smtpPort
SMTP_SECURE=$smtpSecure
SMTP_EMAIL=$smtpEmail
SMTP_USERNAME=$smtpUsername
SMTP_PASSWORD=$smtpPassword

RECAPTCHA_SITE_KEY=$recaptchaSite
RECAPTCHA_SECRET_KEY=$recaptchaSecret

GOOGLE_TAG=$googleTag

VERSION=1.0.0
ENV;

    // .env dosyasını yaz
    file_put_contents(__DIR__ . '/.env', $envContent);

    // .htaccess dosyasını oluştur
    $htaccess = <<<HTACCESS
RewriteEngine On

# HTTP'den HTTPS'e yönlendirme
RewriteCond %{HTTPS} off
RewriteRule ^(.*)$ https://%{HTTP_HOST}%{REQUEST_URI} [R=301,L]

# .env dosyasını erişime kapatma
RewriteRule ^\.env$ - [F,L]

# Composer dosyalarını erişime kapatma
RewriteRule ^(composer\.(json|lock))$ - [F,L]

# App ve Vendor klasörlerini erişime kapatma
RewriteRule ^(app|vendor)/ - [F,L]

# Mevcut dosya veya dizin varsa yönlendirme yapma
RewriteCond %{REQUEST_FILENAME} !-f
RewriteCond %{REQUEST_FILENAME} !-d

# Tüm istekleri index.php'ye yönlendir
RewriteRule ^(.*)$ index.php?url=$1 [QSA,L]
HTACCESS;

    file_put_contents(__DIR__ . '/.htaccess', $htaccess);

    // install.lock oluştur
    file_put_contents(__DIR__ . '/install.lock', 'Kurulum tamamlandı: ' . date('Y-m-d H:i:s'));

    try {
        $dsn = "mysql:host=$dbHost;dbname=$dbName;charset=utf8mb4";
        $pdo = new PDO($dsn, $dbUser, $dbPass);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        // SQL dump dosyasını içeri al
        $sqlDump = file_get_contents(__DIR__ . '/setup.sql');
        $pdo->exec($sqlDump);

        // Admin kullanıcıyı uyeler tablosuna ekle
        $hashedPassword = password_hash($adminPassword, PASSWORD_DEFAULT);
        $stmt = $pdo->prepare("INSERT INTO uyeler (user_ad, user_soyad, user_kod, user_email, user_parola, user_yetki) VALUES (?, ?, ?, ?, ?, 9)");
        $stmt->execute(['Admin', 'User', 'admin', $adminEmail, $hashedPassword]);

        // app_settings tablosuna başlangıç verileri ekle
        $yearNow = date('Y');
        $stmt = $pdo->prepare("INSERT INTO app_settings (setting_key, setting_value) VALUES (?, ?)");

        $defaultSettings = [
            'multilingual' => '1',
            'title' => $editedSiteUrl,
            'url' => $editedSiteUrl,
            'description_en' => '',
            'description_tr' => '',
            'keywords_en' => '',
            'keywords_tr' => '',
            'logo' => 'https://downloads.boacore.com/images/logo.png',
            'logo_dark' => 'https://downloads.boacore.com/images/logo-dark.png',
            'user_login' => '2',
            'email' => $adminEmail,
            'telephone' => '',
            'footer_info' => 'Welcome to ' . $editedSiteUrl,
            'yil' => $yearNow,
            'theme' => 'boa-basic',
            'admin_att' => 'Yönetim sayfasına hoşgeldin.',
            'maintenance_mode' => '2',
            'maintenance_mode_title' => 'Maintenance Mode',
            'maintenance_mode_description' => 'We are working on it, please try again later.',
            'footer_about_text_en' => 'Welcome to ' . $editedSiteUrl,
            'footer_about_text_tr' => 'Welcome to ' . $editedSiteUrl
        ];

        foreach ($defaultSettings as $key => $value) {
            $stmt->execute([$key, $value]);
        }

        // setup.sql dosyasını sil
        @unlink(__DIR__ . '/setup.sql');

    } catch (Exception $e) {
        die("Veritabanı kurulumu başarısız: " . $e->getMessage());
    }

    @unlink(__FILE__);
    header('Location: /');
    exit;
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Kurulum - Website Base</title>
    <style>
        body { font-family: sans-serif; background: #f4f4f4; padding: 2rem; }
        form { max-width: 600px; margin: auto; background: white; padding: 2rem; border-radius: 8px; box-shadow: 0 0 10px #ccc; }
        input { width: 100%; margin-bottom: 1rem; padding: .75rem; font-size: 1rem; }
        button { padding: .75rem 1.5rem; font-size: 1rem; }
        .error { color: red; margin-bottom: 1rem; }
    </style>
</head>
<body>

<form method="post">
    <h2>Website Kurulumu</h2>

    <?php if ($error): ?>
        <div class="error"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <input type="text" name="site_url" placeholder="Site URL (örn: https://example.com)" required>
    <input type="text" name="db_host" placeholder="Veritabanı Sunucusu (örn: localhost)" required>
    <input type="text" name="db_name" placeholder="Veritabanı Adı" required>
    <input type="text" name="db_user" placeholder="Veritabanı Kullanıcı Adı" required>
    <input type="password" name="db_pass" placeholder="Veritabanı Şifresi">

    <hr>
    <input type="email" name="admin_email" placeholder="Admin E-Posta" required>
    <input type="password" name="admin_password" placeholder="Admin Şifre" required>

    <hr>
    <h3>SMTP Ayarları</h3>
    <input type="text" name="smtp_address" placeholder="SMTP Sunucu">
    <input type="text" name="smtp_port" placeholder="SMTP Port (Varsayılan: 587)" value="587">
    <input type="text" name="smtp_secure" placeholder="SMTP Güvenlik (Varsayılan: tls)" value="tls">
    <input type="email" name="smtp_email" placeholder="SMTP Gönderici Mail">
    <input type="text" name="smtp_username" placeholder="SMTP Kullanıcı Adı">
    <input type="password" name="smtp_password" placeholder="SMTP Şifresi">

    <hr>
    <h3>Google Ayarları</h3>
    <input type="text" name="recaptcha_site" placeholder="Google Recaptcha Site Key">
    <input type="text" name="recaptcha_secret" placeholder="Google Recaptcha Secret Key">
    <input type="text" name="google_tag" placeholder="Google Tag Kodu">

    <button type="submit">Kurulumu Tamamla</button>
</form>

</body>
</html>
