<?php
// Tum tanimlamalar icin
require 'global.php';

// HATALARI GÖSTERME AYARI
if ($errorSHOW == 1):
    error_reporting(E_ALL);
    ini_set("display_errors", 1);
endif;

// Dil kontrolünden muaf olan bölümleri belirleyen fonksiyon
function getExcludedRoutes()
{
    global $ExcludedRoutes;
    
    return $ExcludedRoutes;
}

require __DIR__ . '/app/init.php';
require 'vendor/autoload.php';

// Çoklu dil desteği aktif mi?
$multilingual = setting('multilingual') == 1;
if (!$multilingual) {
    $supportedLanguages = [$defaultLanguage];
}

// URL'yi al ve parçala
$_url = getURL('url');
$_urlParts = array_filter(explode('/', $_url));

// Varsayılan dil ayarı
$selectedLanguage = $defaultLanguage ?? 'en';
$pageIndex = 0; // Sayfa indeksini başlangıçta belirle

// Eğer URL'nin ilk segmenti dil kontrolünden muafsa, çoklu dil kontrolü yapma
if (!empty($_urlParts[0]) && in_array($_urlParts[0], getExcludedRoutes())) {
    $pageIndex = 0; // Dil muaf olduğu için index kaydırma yapma
} elseif ($multilingual) {
    // Eğer URL'de dil varsa ve desteklenen bir dilse
    if (!empty($_urlParts[0]) && in_array($_urlParts[0], $supportedLanguages)) {
        $selectedLanguage = $_urlParts[0];
        setcookie('user_language', $selectedLanguage, time() + (86400 * 30), "/");
        $pageIndex = 1; // Dil kodu varsa, sayfa ismi bir sonraki elemandır
    } elseif (isset($_COOKIE['user_language']) && in_array($_COOKIE['user_language'], $supportedLanguages)) {
        $selectedLanguage = $_COOKIE['user_language'];
    } else {
        setcookie('user_language', $defaultLanguage, time() + (86400 * 30), "/");
    }

    // SEO için yönlendirme yaparken **dil muaf sayfalarda yönlendirme yapma**
    if (empty($_urlParts[0]) || !in_array($_urlParts[0], $supportedLanguages)) {
        $redirectUrl = "/$selectedLanguage/" . implode('/', $_urlParts);
        if (!in_array($_urlParts[0], getExcludedRoutes())) {
            header("Location: $redirectUrl");
            exit;
        }
    }

    // Gettext dil ayarlarını güncelle
    $currentLanguage = $localeMap[$selectedLanguage] ?? 'en_US.UTF-8';
    $locale = $currentLanguage;
    $domain = 'messages';
    $localeFolder = __DIR__ . '/languages';

    putenv("LANG=$locale");
    setlocale(LC_ALL, $locale);
    bindtextdomain($domain, $localeFolder);
    textdomain($domain);
    bind_textdomain_codeset($domain, 'UTF-8');
}

// Eğer çoklu dil kapalıysa, sayfa indeksini 0 olarak bırak
if (!$multilingual) {
    $pageIndex = 0;
}

// **Gerçek sayfa belirleme** (Eğer çok dilli yapı açıksa index 1'den başlar, değilse 0)
$page = $_urlParts[$pageIndex] ?? 'index';

// Eğer sayfa dosyası yoksa 404'e yönlendir
if (!file_exists(controller($page))) {
    $page = '404';
}

// Bakım modu kontrolü
if (setting('maintenance_mode') == 1 && $page != 'manage') {
    $page = 'maintenance';
}

// Controller'ı çağır
require controller($page);