<?php
/**
 * =============================================
 * 🌐 GLOBAL CONFIGURATION FILE
 * Site-wide Definitions & Settings
 * Created by Ozer Aksoy - 2025 - Chicago 🏙️
 * =============================================
 *
 * ⚠️ UYARI: Bu dosyada yapilan degisiklikler dogrudan siteyi etkiler!
 * Lütfen yedek almadan degisiklik yapmayiniz.
 */

// Hata Gösterimi
// 1: Geliştirme sürecinde hataların ekrana yazdırılması için
// 0: Canlı ortamda hataların gizlenmesi için
$errorSHOW = 1;
// $errorSHOW = 0;

// 🌐 Sosyal Medya Platformları Tanımları

// - Yeni bir platform eklemek için aşağıdaki formata sadık kalın:
//   'platform_key' => [
//       'name' => 'Platform İsmi',
//       'base' => 'https://example.com/',
//       'icon' => 'FontAwesome Icon Class',
//       'class' => 'Canvas Theme Hover Class'
//   ]

// - icon: Font Awesome 6 ile uyumlu olmalı.
// - class: Canvas temasının hover efektleriyle uyumlu arka plan sınıfı.

// 🔒 Bu yapı sabit olup frontend'de kullanıcıya gösterilecek bağlantıları düzenlemek için kullanılabilir.
$availablePlatforms = [
    'facebook' => ['name' => 'Facebook', 'base' => 'https://facebook.com/', 'icon' => 'fa-brands fa-facebook-f', 'class' => 'h-bg-facebook'],
    'twitter' => ['name' => 'Twitter (X)', 'base' => 'https://x.com/', 'icon' => 'fa-brands fa-x-twitter', 'class' => 'h-bg-x-twitter'],
    'instagram' => ['name' => 'Instagram', 'base' => 'https://instagram.com/', 'icon' => 'fa-brands fa-instagram', 'class' => 'h-bg-instagram'],
    'linkedin' => ['name' => 'LinkedIn', 'base' => 'https://linkedin.com/', 'icon' => 'fa-brands fa-linkedin', 'class' => 'h-bg-linkedin'],
    'youtube' => ['name' => 'YouTube', 'base' => 'https://youtube.com/', 'icon' => 'fa-brands fa-youtube', 'class' => 'h-bg-youtube'],
    'reddit' => ['name' => 'Reddit', 'base' => 'https://reddit.com/', 'icon' => 'fa-brands fa-reddit', 'class' => 'h-bg-reddit'],
    'tiktok' => ['name' => 'TikTok', 'base' => 'https://tiktok.com/@', 'icon' => 'fa-brands fa-tiktok', 'class' => 'h-bg-tiktok'],
    'pinterest' => ['name' => 'Pinterest', 'base' => 'https://pinterest.com/', 'icon' => 'fa-brands fa-pinterest', 'class' => 'h-bg-pinterest'],
    'github' => ['name' => 'GitHub', 'base' => 'https://github.com/', 'icon' => 'fa-brands fa-github', 'class' => 'h-bg-github'],
    'threads' => ['name' => 'Threads', 'base' => 'https://www.threads.net/@', 'icon' => 'fa-brands fa-threads', 'class' => 'h-bg-threads'],
    'snapchat' => ['name' => 'Snapchat', 'base' => 'https://snapchat.com/add/', 'icon' => 'fa-brands fa-snapchat-ghost', 'class' => 'h-bg-snapchat'],
    'whatsapp' => ['name' => 'WhatsApp', 'base' => 'https://wa.me/', 'icon' => 'fa-brands fa-whatsapp', 'class' => 'h-bg-whatsapp'],
    'telegram' => ['name' => 'Telegram', 'base' => 'https://t.me/', 'icon' => 'fa-brands fa-telegram', 'class' => 'h-bg-telegram'],
    'discord' => ['name' => 'Discord', 'base' => 'https://discord.com/users/', 'icon' => 'fa-brands fa-discord', 'class' => 'h-bg-discord'],
    'tumblr' => ['name' => 'Tumblr', 'base' => 'https://tumblr.com/', 'icon' => 'fa-brands fa-tumblr', 'class' => 'h-bg-tumblr'],
    'dribbble' => ['name' => 'Dribbble', 'base' => 'https://dribbble.com/', 'icon' => 'fa-brands fa-dribbble', 'class' => 'h-bg-dribbble'],
    'behance' => ['name' => 'Behance', 'base' => 'https://behance.net/', 'icon' => 'fa-brands fa-behance', 'class' => 'h-bg-behance'],
    'medium' => ['name' => 'Medium', 'base' => 'https://medium.com/@', 'icon' => 'fa-brands fa-medium', 'class' => 'h-bg-medium'],
    'skype' => ['name' => 'Skype', 'base' => 'skype:', 'icon' => 'fa-brands fa-skype', 'class' => 'h-bg-skype']
];

/*
🚫 Dil Yönlendirmesinden Hariç Tutulacak Rotalar

Çoklu dil sistemi aktifken, bazı rotaların otomatik yönlendirme kurallarından muaf tutulması gerekir.
Örneğin: AJAX istekleri, robots.txt, özel landing sayfaları gibi.

Bu listeye eklenecek yeni sayfalar için örnek:
['robots.txt', 'sitemap.xml', 'api', 'landing']

❗ DİKKAT: Sistemin çalışması için bazı rotalar mutlaka burada kalmalıdır.
*/
$ExcludedRoutes = ['manage', 'landing', 'ajax', 'robots.txt', 'sitemap.xml'];

/*
🌍 Dil Ayarları

- $supportedLanguages: Kullanıcıların seçebileceği dillerin ISO kodları (örn. 'en', 'tr').
- $defaultLanguage: Sayfanın varsayılan dili. Yalnızca yukarıdaki listede olan bir değer olmalı.
- $localeMap: gettext çeviri fonksiyonu için sistem locale karşılıkları.

📁 Her dil için aşağıdaki gibi bir klasör yapısı kurulmalıdır:
    languages/
      └── en_US/
          └── LC_MESSAGES/
              ├── messages.po
              └── messages.mo

💡 .po ve .mo dosyaları hakkında bilginiz yoksa lütfen yardım alın.
*/
$supportedLanguages = ['en', 'tr'];
$defaultLanguage = 'en';
$localeMap = [
    'tr' => 'tr_TR.UTF-8',
    'en' => 'en_US.UTF-8',
];

