<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?=$errorTitle . ' - ' . setting('title')?></title>
    <style>
        :root {
            --primary-color: #1e1e2f;
            --accent-color: #ff5e5e;
            --text-color: #333;
            --bg-color: #f9f9f9;
            --font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background-color: var(--bg-color);
            color: var(--text-color);
            font-family: var(--font-family);
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            text-align: center;
            padding: 1rem;
        }

        .error-container {
            max-width: 600px;
        }

        .error-code {
            font-size: 6rem;
            font-weight: bold;
            color: var(--accent-color);
        }

        .error-message {
            font-size: 1.5rem;
            margin-top: 1rem;
            color: var(--primary-color);
        }

        .error-description {
            margin-top: 0.5rem;
            font-size: 1rem;
            line-height: 1.6;
            color: #555;
        }

        .error-actions {
            margin-top: 2rem;
        }

        .error-actions a {
            text-decoration: none;
            color: white;
            background-color: var(--accent-color);
            padding: 0.75rem 1.5rem;
            border-radius: 6px;
            transition: background-color 0.3s ease;
            margin: 0 0.5rem;
            display: inline-block;
        }

        .error-actions a:hover {
            background-color: #e04848;
        }
    </style>
</head>
<body>