<div class="container pt-3 pb-2">

<?php 
if ($UyeBen==1):
?>

  <!-- Post form -->
  <div class="card mb-3">
    <div class="card-body">
      <form id="feedPostForm">
        <?php $_SESSION['tokenMuaf'] = true; ?>
        <input type="hidden" name="token" value="<?= $_SESSION['token'] ?>">
        <div class="mb-3">
          <textarea name="paylasim" class="form-control" rows="3" placeholder="<?= _('Share something...') ?>"></textarea>
        </div>
        <div class="d-flex justify-content-end">
          <button type="submit" class="btn btn-primary"><?= _('Post') ?></button>
        </div>
      </form>
    </div>
  </div>

  <!-- Feed Items -->
  <div id="feed-container">
  <div id="feedLoader" class="text-center my-3" style="display:none;">
    <div class="col-lg-3 col-md-4 col-6 mx-auto" style="height:12.5rem;">
      <div class="css3-spinner" style="--cnvs-loader-color:var(--cnvs-themecolor);">
        <div class="css3-spinner-grid-pulse">
          <div></div><div></div><div></div>
          <div></div><div></div><div></div>
          <div></div><div></div><div></div>
        </div>
      </div>
    </div>
  </div>
    <?php
    $icerikler = $Veri->from('paylasimlar')->where('paylasim_onay=:onay')->order('paylasim_tarih DESC LIMIT 0, 10')->selectAll(['onay' => 1]);
else:
    echo '<div id="feed-container">';
    $icerikler = $Veri->from('paylasimlar')->where('paylasim_user_id=:id')->order('paylasim_tarih DESC LIMIT 0, 100')->selectAll(['id' => $UyeId]);
endif;
    if ($icerikler):
      foreach ($icerikler as $post):
        $GonderenKisi = $Uye->Kisi($post['paylasim_user_id'],'user_ad,user_soyad,user_kod,user_resim');
        $GonderenKisiYaz = '<a href="' . site_url('u/' . $GonderenKisi['user_kod']) . '" target="_blank">' . $GonderenKisi['user_ad'] . ' ' . $GonderenKisi['user_soyad'] . '</a>';
        ?>
        <div class="card mb-3">
          <div class="card-body d-flex">
            <div class="me-3">
              <img src="<?= !empty($GonderenKisi['user_resim']) ? $GonderenKisi['user_resim'] : public_url('images/nophoto.jpg') ?>" alt="Avatar" class="rounded-circle" width="48" height="48">
            </div>
            <div class="flex-grow-1">
              <div class="d-flex justify-content-between align-items-center mb-1">
                <div class="fw-bold"><?= $GonderenKisiYaz ?></div>
                <?php
                  $createdAt = strtotime($post['paylasim_tarih']);
                  $now = time();
                  $diffInSeconds = $now - $createdAt;
                  $threeDaysInSeconds = 3 * 24 * 60 * 60;
                  if ($diffInSeconds > $threeDaysInSeconds):
                ?>
                  <small class="text-muted"><span class="utc-time" data-utc="<?= date('c', $createdAt) ?>"></span></small>
                <?php else: ?>
                  <small class="text-muted"><?= time_elapsed_string($post['paylasim_tarih']) ?></small>
                <?php endif; ?>
              </div>
              <p class="mb-2"><?= nl2br(strip_tags($post['paylasim_metin'])) ?></p>
              <div class="d-flex gap-3">
                <?php
                $likeCount = $Veri->from('paylasim_likes')->where('like_paylasim_id = :pid AND like_type = 1')->count(['pid' => $post['paylasim_id']]);
                $dislikeCount = $Veri->from('paylasim_likes')->where('like_paylasim_id = :pid AND like_type = 0')->count(['pid' => $post['paylasim_id']]);
                ?>
                <a href="#" class="like-btn text-decoration-none" data-id="<?= $post['paylasim_id'] ?>" data-type="1">👍 <span class="like-count"><?= $likeCount ?></span></a>
                <a href="#" class="like-btn text-decoration-none" data-id="<?= $post['paylasim_id'] ?>" data-type="0">👎 <span class="dislike-count"><?= $dislikeCount ?></span></a>
              </div>
            </div>
          </div>
        </div>
        <?php
      endforeach;
    else:
      echo '<div class="alert alert-info">' . _('No posts yet.') . '</div>';
    endif;
    ?>
  </div>

  <?php if ($UyeBen==1): ?>
  <!-- Load more -->
  <div class="text-center mt-3 mb-2">
    <button id="loadMoreBtn" class="btn btn-outline-secondary"><?= _('Load more') ?></button>
  </div>
  <?php endif; ?>

</div>

<script>
let currentPage = 1;
let loading = false;

document.getElementById("loadMoreBtn").addEventListener("click", function () {
  if (loading) return;
  loading = true;

  const loader = document.getElementById("feedLoader");
  loader.style.display = "block";
  currentPage++;

  fetch("<?= site_url('ajax/load-feed') ?>?page=" + currentPage)
    .then(res => res.text())
    .then(html => {
      loader.style.display = "none";
      loading = false;

      const container = document.getElementById("feed-container");

      if (html.trim() === "") {
        document.getElementById("loadMoreBtn").style.display = "none";
        const info = document.createElement("div");
        info.className = "alert alert-info text-center mt-3 mb-2";
        info.textContent = "<?= _('No more posts to show.') ?>";
        container.appendChild(info);
      } else {
        container.insertAdjacentHTML("beforeend", html);
        if (container.querySelector(".js-feed-end")) {
          document.getElementById("loadMoreBtn").style.display = "none";
          const info = document.createElement("div");
          info.className = "alert alert-info text-center mt-3 mb-2";
          info.textContent = "<?= _('No more posts to show.') ?>";
          container.appendChild(info);
        }
      }
    })
    .catch(() => {
      loader.style.display = "none";
      loading = false;
    });
});

document.getElementById("feedPostForm").addEventListener("submit", function (e) {
  e.preventDefault();

  const form = e.target;
  const formData = new FormData(form);
  const text = formData.get("paylasim").trim();
  if (!text) return;

  fetch("<?= site_url('ajax/profil-paylasim') ?>", {
    method: "POST",
    body: formData
  })
  .then(res => res.text())
  .then(html => {
    const container = document.getElementById("feed-container");
    container.insertAdjacentHTML("afterbegin", html);
    form.reset();
  });
});
</script>
<script>
document.querySelectorAll('.like-btn').forEach(btn => {
  btn.addEventListener('click', function (e) {
    e.preventDefault();
    const id = this.dataset.id;
    const type = this.dataset.type;

    fetch("<?= site_url('ajax/like-toggle') ?>", {
      method: "POST",
      headers: { "Content-Type": "application/x-www-form-urlencoded" },
      body: `id=${id}&type=${type}`
    })
    .then(res => res.json())
    .then(data => {
      if (data.success) {
        const card = this.closest('.card');
        card.querySelector('.like-count').textContent = data.likes;
        card.querySelector('.dislike-count').textContent = data.dislikes;
      }
    });
  });
});
</script>
</file>
