<?php
$URLgelenID = _url(2);
$ticket = $Veri->from('destek')->where('spt_id=:id AND spt_onay=:approved')->selectOne(["id" => $URLgelenID, "approved" => 1]);
if ($ticket):
  $SPTid = $ticket['spt_id'];
  $SPTuserID = $ticket['spt_userID'];
  $SPTonem = $ticket['spt_onem'];
  $SPTbaslik = $ticket['spt_baslik'];
  $SPTmetin = $ticket['spt_metin'];
  $SPTtarih = $ticket['spt_tarih'];
  $SPTpublic = $ticket['spt_public'];
  $SPTacik = $ticket['spt_acik'];
  
  $author = $User->Kisi($SPTuserID);
  $SPTuserAD = $author ? '<a href="' . site_url('profile/' . $author['user_kod']) . '" target="_blank">' . $author['user_ad'] . ' ' . $author['user_soyad'] . '</a>' : '';
else:
  header('Location: ' . site_url('support'));
  exit;
endif;
?>

<?php
$toolMainTitle = _('Support');
$toolSubTitle = $SPTbaslik;
$menuItems = [
  [
    'url' => 'support',
    'title' => 'Support'
  ],
  [
    'url' => '#',
    'title' => 'Ticket Details'
  ]
];
require view('static/toolbar');

?>

<?php require view('static/support/static/head') ?>

    <!-- VIEW DETAILS -->
    <div class="row">
      <div class="col-sm-12">
        <?php
        echo '
        <h2>' . $SPTbaslik . '<br><small>' . ( ($SPTacik==1) ? '<strong><font color="red">' . _('Open') . '</font></strong>' : '<strong><font color="green">' . _('Closed') . '</font></strong>' ) . ' | ' . ( ($SPTpublic==1) ? _('Visible to everyone') : _('Only me') ) . '</small></h2>
        <p><font size="-1"><em>' . $SPTuserAD . ' - ' . _('Date') . ': ' . date("d.m.Y H:i", strtotime($SPTtarih)) . '</em></font></p>
        <hr>
        <p>' . $SPTmetin . '</p>
        <hr>
        ';
        if ((isset($BUYEyetki)) && (($BUYEyetki > 4) || ($SPTuserID == $BUYEid))):
          echo '
          <form method="post" action="">
          <input type="hidden" name="token" value="' . $_SESSION['token'] . '">
          <input type="hidden" name="sptID" value="' . $SPTid . '">
            ' . ( ($SPTacik==1) ? '<button type="submit" name="close" class="btn btn-success">' . _('Mark as resolved') . '</button>' : '<button type="submit" name="open" class="btn btn-danger">' . _('Reopen ticket') . '</button>' ) . ' 
            <button type="submit" name="delete" class="btn btn-danger"><span class="glyphicon glyphicon-trash"></span> <strong>' . _('DELETE') . '</strong> (' . _('Cannot be undone') . ')</button>
          </form>
          <hr>
          ';
        endif;
        echo '<h4>' . _('Responses') . '</h4><hr>';
        $responses = $Veri->from('destekCevap')->where('ans_supportID=:supportID AND ans_onay=:approved')->order('ans_tarih DESC')->selectAll(["supportID" => $SPTid, "approved" => 1]);
        if ($responses):
          foreach($responses as $response):
            $responseUser = $User->Kisi($response['ans_userID']);
            $ANSuserAD = $responseUser ? '<a href="' . site_url('profile/' . $responseUser['user_kod']) . '" target="_blank">' . $responseUser['user_ad'] . ' ' . $responseUser['user_soyad'] . '</a>' : '';
            echo '
              <div class="well">
                <p>
                  ' . $response['ans_metin'] . '<br>
                  <font size="-1" color="grey">
                    <em>
                      ' . $ANSuserAD . ' ' . _('responded on') . ' ' . date("d.m.Y H:i", strtotime($response['ans_tarih'])) . '
                    </em>
                  </font><br>
                  <form method="post" action="">
                  <input type="hidden" name="token" value="' . $_SESSION['token'] . '">
                  <input type="hidden" name="ansID" value="' . $response['ans_id'] . '">
                  <button type="submit" name="like" class="btn btn-success btn-xs"><span class="glyphicon glyphicon-thumbs-up"></span> ' . $response['ans_iyi'] . '</button> 
                  <button type="submit" name="dislike" class="btn btn-danger btn-xs"><span class="glyphicon glyphicon-thumbs-down"></span> ' . $response['ans_kotu'] . '</button>
                  </form>
                </p>
              </div>
            ';
          endforeach;
        endif;
        if ((isset($BUYEyetki)) && (($BUYEyetki > 4) || ($SPTuserID == $BUYEid))):
          echo '<div class="row"><div class="col-sm-12">';
          require view('static/forms/yeni-etiketcevap');
          echo '</div></div>';
        endif;
        ?>
      </div>
    </div>
    <!-- VIEW DETAILS -->

<?php require view('static/support/static/foot') ?>