<?php
$toolMainTitle = _('Support');
$toolSubTitle = _('Search previous tickets or create a new one');
$menuItems = [
  [
    'url' => 'support',
    'title' => 'Support'
  ],
  [
    'url' => '#',
    'title' => 'Search on Tickets'
  ]
];
require view('static/toolbar');
?>

<?php require view('static/support/static/head') ?>

    <!-- SEARCH -->
    <div class="row">
      <div class="col-sm-12">
        <form id="searchTicket" method="post" action="">
          <input type="hidden" name="token" value="<?= $_SESSION['token'] ?>">
          <div class="input-group">
            <input type="text" id="searchTicket" name="keyword" class="form-control" placeholder="<?= _('Describe your issue') ?>">
            <span class="input-group-btn">
              <button class="btn btn-primary" id="searchTicket" type="submit" name="search"><i class="fa fa-search"></i> <?= _('Search Support') ?></button>
            </span>
          </div>
        </form>
      </div>
    </div>
    <!-- SEARCH -->

    <!-- SEARCH RESULTS -->
    <div class="row">
      <div class="col-sm-12">
        <?php
        if (post('keyword')):
          $keyword = post('keyword');
        else:
          $keyword = setting('title');
        endif;
        echo '<hr><h4>"' . $keyword . '" ' . _('search results') . '</h4><hr>';
        
        $searchResults = $Veri->from('destek')->where('spt_onay=:approved AND spt_public=:public AND spt_acik=:open AND ((spt_baslik LIKE :keyword) OR (spt_metin LIKE :keyword))')->order('spt_tarih DESC')->selectAll(["approved" => 1, "public" => 1, "open" => 0, "keyword" => '%'.$keyword.'%']);
        
        if ($searchResults):
          foreach($searchResults as $result):
            echo '
              <h4><a href="' . site_url('support/view/' . $result['spt_id']) . '">' . $result['spt_baslik'] . '</a></h4>
              <p>' . substr(strip_tags($result['spt_metin']), 0, 200) . '...<br>
              <font size="-1" color="grey"><em>' . date("d.m.Y H:i", strtotime($result['spt_tarih'])) . ' ' . _('added on') . '.</em></font></p>
              <hr>
            ';
          endforeach;
        endif;
        ?>
      </div>
    </div>
    <!-- SEARCH RESULTS -->

<?php require view('static/support/static/foot') ?>