<?php
$toolMainTitle = _('Support');
$toolSubTitle = _('Search previous tickets or create a new one');
$menuItems = [
  [
    'url' => 'support',
    'title' => 'Support'
  ],
  [
    'url' => '#',
    'title' => 'My Requests'
  ]
];
require view('static/toolbar');
?>

<?php require view('static/support/static/head') ?>

    <!-- YOUR SUBMITTED REQUESTS -->
    <div class="row">
      <div class="col-sm-12">
        <?php
        $userTickets = $Veri->from('destek')->where('spt_userID=:userID AND spt_onay=:approved')->order('spt_tarih DESC LIMIT 0,10')->selectAll(["userID" => $BUYEid, "approved" => 1]);
        echo '<h4>' . _('All your requests') . '</h4><hr>';
        if ($userTickets):
          foreach($userTickets as $ticket):
            echo '
              <h4><a href="' . site_url('support/view/' . $ticket['spt_id']) . '">' . $ticket['spt_baslik'] . '</a><br><small>' . ( ($ticket['spt_acik'] == 1) ? '<strong><font color="red">' . _('OPEN') . '</font></strong>' : '<strong><font color="green">' . _('CLOSED') . '</font></strong>' ) . ' | ' . ( ($ticket['spt_public'] == 1) ? _('Visible to everyone') : _('Only me') ) . '</small></h4>
              <p>' . substr(strip_tags($ticket['spt_metin']), 0, 200) . '...<br>
              <font size="-1" color="grey"><em>' . date("d.m.Y H:i", strtotime($ticket['spt_tarih'])) . ' ' . _('added by') . ' <a href="/profile">' . _('you') . '</a>.</em></font></p>
              <hr>
            ';
          endforeach;
        endif;
        ?>
      </div>
    </div>
    <!-- YOUR SUBMITTED REQUESTS -->

<?php require view('static/support/static/foot') ?>