<?php
$toolMainTitle = _('Support');
$toolSubTitle = _('Search previous tickets or create a new one');
$menuItems = [
  [
    'url' => '#',
    'title' => 'Support'
  ]
];
require view('static/toolbar');
?>

<?php require view('static/support/static/head') ?>

      <!-- page-index
      ============================================= -->
      <!-- SEARCH -->
      <div class="row">
          <div class="col-sm-12">
            <form id="searchTicket" method="post" action="support/search">
              <input type="hidden" name="token" value="<?= $_SESSION['token'] ?>">
              <div class="input-group">
                <input type="text" id="searchTicket" name="keyword" class="form-control" placeholder="<?= _('Describe your issue') ?>">
                <span class="input-group-btn">
                  <button class="btn btn-primary" id="searchTicket" type="submit" name="search"><i class="fa fa-search"></i> <?= _('Search Support') ?></button>
                </span>
              </div>
            </form>
          </div>
        </div>
        <!-- SEARCH -->

        <!-- RECENTLY RESOLVED PUBLIC ISSUES -->
        <div class="row">
          <div class="col-sm-12">
            <?php
            $ticketList = $Veri->from('destek')->where('spt_public=:public AND spt_onay=:approved AND spt_acik=:open')->order('spt_tarih DESC LIMIT 0,10')->selectAll(["public" => 1, "approved" => 1, "open" => 0]);
            if ($ticketList):
              echo '<hr><h4>' . _('Recent Public Support Requests') . '</h4><hr>';
              foreach($ticketList as $ticket):
                echo '
                  <h4><a href="' . site_url('support/view/' . $ticket['spt_id']) . '">' . $ticket['spt_baslik'] . '</a></h4>
                  <p>' . substr(strip_tags($ticket['spt_metin']), 0, 200) . '...<br>
                  <font size="-1" color="grey"><em>' . date("d.m.Y H:i", strtotime($ticket['spt_tarih'])) . ' ' . _('added on') . '.</em></font></p>
                  <hr>
                ';
              endforeach;
            else:
              echo '<hr><h4>' . _('No completed public support requests found.') . '</h4><hr>';
            endif;
            ?>
          </div>
        </div>
        <!-- RECENTLY RESOLVED PUBLIC ISSUES -->

<?php require view('static/support/static/foot') ?>