	<?php
	$topMenuKey = 'header_topmenu_' . $selectedLanguage;
	$mainMenuKey = 'header_mainmenu_' . $selectedLanguage;

	$headerTopMenu = setting($topMenuKey) ? get_menu(setting($topMenuKey)) : [];
	$headerMainMenu = setting($mainMenuKey) ? get_menu(setting($mainMenuKey)) : [];
	?>
	<!-- Document Wrapper
	============================================= -->
	<div id="wrapper">

		<!-- Top Bar
		============================================= -->
		<div id="top-bar">
			<div class="container">

				<div class="row justify-content-between align-items-center">
					<div class="col-12 col-md-auto">

						<!-- Top Links
						============================================= -->
						<div class="top-links on-click">
							<ul class="top-links-container">
								<?php if (!empty($headerTopMenu)): ?>
									<?php foreach ($headerTopMenu as $item): ?>
										<li class="top-links-item"><a href="<?= htmlspecialchars($item['url']) ?>"><?= htmlspecialchars($item['title']) ?></a></li>
									<?php endforeach; ?>
								<?php endif; ?>
								<?php if (setting('multilingual') == 1): ?>
								<li class="top-links-item">
									<a href="#"><?= strtoupper($selectedLanguage) ?></a>
									<ul class="top-links-sub-menu">
										<?php foreach ($supportedLanguages as $lang): ?>
											<?php if ($lang !== $selectedLanguage): ?>
												<li class="top-links-item">
													<a href="<?= site_url($lang) ?>">
														<img src="<?= public_url("images/flags/$lang.png") ?>" alt="<?= ucfirst($lang) ?>"> <?= strtoupper($lang) ?>
													</a>
												</li>
											<?php endif; ?>
										<?php endforeach; ?>
									</ul>
								</li>
								<?php endif; ?>
								<?php if ((setting('user_login')==1)&&((_url(0)!='register')&&(_url(0)!='forgot')&&(_url(0)!='login'))): ?>
								<?php if ((isset($BUYElogin))&&($BUYElogin==true)): ?>
								<li class="top-links-item"><a href="#"><?=_('My Profile')?></a>
									<ul class="top-links-sub-menu">
										<li class="top-links-item"><a href="<?=site_url('u/' . $BUYEkod)?>"><?=_('Profile')?></a></li>
										<li class="top-links-item"><a href="<?=site_url('u/' . $BUYEkod . '/settings')?>"><?=_('Settings')?></a></li>
										<li class="top-links-item"><a href="<?=site_url('logout')?>"><?=_('Logout')?></a></li>
									</ul>
								</li>
								<?php else: ?>
								<li class="top-links-item">
									<?php if (setting('outdoor_active')): ?>
									<a href="<?=site_url('login')?>"><?=_('Login')?></a>
									<?php else: ?>
									<a href="#"><?=_('Login')?></a>
									<div class="top-links-section">
										<form id="top-login" autocomplete="off" method="post" action="login">
										<input type="hidden" name="token" value="<?=$_SESSION['token']?>">
											<div class="form-group">
												<label>Username</label>
												<input type="email" name="user_email" class="form-control" placeholder="Email address">
											</div>
											<div class="form-group">
												<label>Password</label>
												<input type="password" name="user_parola" class="form-control" placeholder="Password" required="">
											</div>
											<div class="form-group form-check">
												<input class="form-check-input" type="checkbox" name="remember" value="" id="top-login-checkbox" checked>
												<label class="form-check-label" for="top-login-checkbox"><?=_('Remember me for 30 days')?></label>
											</div>
											<input type="hidden" name="recaptcha_Cevap" id="recaptchaCevabi">
											<button type="submit" name="giris" class="btn btn-danger w-100"><?=_('Log In')?></button>
										</form><br>
										<a class="text-link" href="<?=site_url('register')?>" ><?=_('Create Account')?></a> | <a class="text-link" href="<?=site_url('forgot')?>" ><?=_('Forgot')?></a>
									</div>
									<?php endif; ?>
								</li>
								<?php endif; ?>
								<?php endif; ?>
							</ul>
						</div><!-- .top-links end -->

					</div>

					<div class="col-12 col-md-auto">

						<!-- Top Social
						============================================= -->
						<ul id="top-social">
							<?php 
							$socialJson = setting('social_accounts');
							$socialAccounts = [];
							if (is_string($socialJson) && !empty($socialJson)) {
								$decodedJson = html_entity_decode($socialJson);
								$decoded = json_decode($decodedJson, true);
								if (json_last_error() === JSON_ERROR_NONE && is_array($decoded)) {
									$socialAccounts = $decoded;
								}
							}
							if (!empty($socialAccounts) && is_array($socialAccounts)) {
								foreach ($socialAccounts as $item) {
									$platform = $item['platform'] ?? null;
									$username = $item['username'] ?? null;
									$title = (strlen($item['title'])>2) ? $item['title'] : $username;
									if ($platform && $username && isset($availablePlatforms[$platform])) {
										$data = $availablePlatforms[$platform];
										$url = rtrim($data['base'], '/') . '/' . ltrim($username, '/');
										echo '<li><a href="' . htmlspecialchars($url) . '" target="_blank" class="' . htmlspecialchars($data['class']) . '"><span class="ts-icon"><i class="' . htmlspecialchars($data['icon']) . '"></i></span><span class="ts-text">' . htmlspecialchars($title) . '</span></a></li>';
									}
								}
							}
							?>
							<?php if (setting('telephone')!=''): ?>
							<li><a href="tel:<?=setting('telephone')?>" class="h-bg-call"><span class="ts-icon"><i class="fa-solid fa-phone"></i></span><span class="ts-text"><?=setting('telephone')?></span></a></li>
							<?php endif; ?>
							<?php if (setting('email')!=''): ?>
							<li><a href="mailto:<?=setting('email')?>" class="h-bg-email3"><span class="ts-icon"><i class="fa-solid fa-envelope"></i></span><span class="ts-text"><?=setting('email')?></span></a></li>
							<?php endif; ?>
						</ul><!-- #top-social end -->

					</div>
				</div>

			</div>
		</div><!-- #top-bar end -->

		<!-- Header
		============================================= -->
		<header id="header">
			<div id="header-wrap">
				<div class="container">
					<div class="header-row">

						<!-- Logo
						============================================= -->
						<div id="logo">
							<a href="<?=site_url()?>">
								<img class="logo-default" srcset="<?=setting('logo')?>, <?=setting('logo')?> 2x" src="<?=setting('logo')?>" alt="<?=setting('title')?>">
								<img class="logo-dark" srcset="<?=setting('logo_dark')?>, <?=setting('logo_dark')?> 2x" src="<?=setting('logo_dark')?>" alt="<?=setting('title')?>">
							</a>
						</div><!-- #logo end -->

						<div class="header-misc">

							<!-- Top Search
							============================================= -->
							<div id="top-search" class="header-misc-icon">
								<a href="#" id="top-search-trigger"><i class="uil uil-search"></i><i class="bi-x-lg"></i></a>
							</div><!-- #top-search end -->
							
							<?php if (setting('user_login')==2): ?>
							<div class="header-misc ms-auto">
							<?php if ((isset($BUYElogin))&&($BUYElogin==true)): ?>
								<div class="btn-group">
									<a class="btn btn-sm btn-outline-primary" role="button" href="<?=site_url('u/' . $BUYEkod)?>"><?=_('My Profile')?></a>
									<button type="button" class="btn btn-sm btn-outline-primary dropdown-toggle dropdown-toggle-split" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
										<span class="visually-hidden">Toggle Dropdown</span>
									</button>
									<div class="dropdown-menu">
										<a class="dropdown-item" href="<?=site_url('u/' . $BUYEkod)?>"><?=_('Profile')?></a>
										<a class="dropdown-item" href="<?=site_url('u/' . $BUYEkod . '/settings')?>"><?=_('Settings')?></a>
										<div class="dropdown-divider"></div>
										<a class="dropdown-item" href="<?=site_url('logout')?>"><?=_('Logout')?></a>
									</div>
								</div>
							<?php else: ?>
								<a href="<?=site_url('login')?>" class="button button-small button-circle button-border button-aqua"><i class="fa-solid fa-user"></i>Login</a>
							<?php endif; ?>
							</div>
							<?php endif; ?>

						</div>

						<div class="primary-menu-trigger">
							<button class="cnvs-hamburger" type="button" title="Open Mobile Menu">
								<span class="cnvs-hamburger-box"><span class="cnvs-hamburger-inner"></span></span>
							</button>
						</div>

						<!-- Primary Navigation
						============================================= -->
						<nav class="primary-menu">

							<ul class="menu-container">
							<?php if (!empty($headerMainMenu)): ?>
								<?php foreach ($headerMainMenu as $item): ?>
									<?php
									$currentUrl = site_url(ltrim($_SERVER['REQUEST_URI'], '/'));
									$menuUrl = trim($item['url'], '/'); 
									$currentUrl = trim($currentUrl, '/');
									$isActive = $currentUrl === $menuUrl ? ' current' : '';
									?>
									<li class="menu-item<?= $isActive ?>"><a class="menu-link" href="<?= htmlspecialchars($item['url']) ?>"><div><?= htmlspecialchars($item['title']) ?></div></a></li>
								<?php endforeach; ?>
							<?php endif; ?>
							</ul>

						</nav><!-- #primary-menu end -->

						<form class="top-search-form" action="search.html" method="get">
							<input type="text" name="q" class="form-control" value="" placeholder="Type &amp; Hit Enter.." autocomplete="off">
						</form>

					</div>
				</div>
			</div>
			<div class="header-wrap-clone"></div>
		</header><!-- #header end -->