<!DOCTYPE html>
<html dir="ltr" lang="en-US">
<head>

    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta http-equiv="x-ua-compatible" content="IE=edge">
    <meta name="author" content="<?=setting('title')?>">
    <meta name="description" content="<?= (isset($GelenDescription)) ? $GelenDescription : setting('description_' . $selectedLanguage) ?>">
    <meta name="keywords" content="<?= (isset($GelenKeywords)) ? $GelenKeywords : setting('keywords_' . $selectedLanguage) ?>">

    <!-- Standard Favicon -->
    <?php if (setting('favicon_ico')): ?>
    <link rel="shortcut icon" href="<?= setting('favicon_ico') ?>" type="image/x-icon">
    <?php endif; ?>

    <!-- PNG Favicons -->
    <?php if (setting('favicon_16')): ?>
    <link rel="icon" type="image/png" sizes="16x16" href="<?= setting('favicon_16') ?>">
    <?php endif; ?>
    <?php if (setting('favicon_32')): ?>
    <link rel="icon" type="image/png" sizes="32x32" href="<?= setting('favicon_32') ?>">
    <?php endif; ?>

    <!-- Apple Touch Icon -->
    <?php if (setting('apple_touch_icon')): ?>
    <link rel="apple-touch-icon" sizes="180x180" href="<?= setting('apple_touch_icon') ?>">
    <?php endif; ?>

    <!-- Android Icons -->
    <?php if (setting('android_icon_192')): ?>
    <link rel="icon" type="image/png" sizes="192x192" href="<?= setting('android_icon_192') ?>">
    <?php endif; ?>
    <?php if (setting('android_icon_512')): ?>
    <link rel="icon" type="image/png" sizes="512x512" href="<?= setting('android_icon_512') ?>">
    <?php endif; ?>
    
    <!-- Font Imports -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&family=Playfair+Display:ital@0;1&display=swap" rel="stylesheet">

    <!-- Core Style -->
    <link rel="stylesheet" href="<?=public_url('style.css')?>">

    <!-- Font Icons -->
    <link rel="stylesheet" href="<?=public_url('css/font-icons.css')?>">

    <!-- Custom CSS -->
    <link rel="stylesheet" href="<?=public_url('css/custom.css')?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Plugins/Components CSS -->
	<link rel="stylesheet" href="<?=public_url('css/components/datepicker.css')?>">
	<link rel="stylesheet" href="<?=public_url('css/components/timepicker.css')?>">
	<link rel="stylesheet" href="<?=public_url('css/components/daterangepicker.css')?>">

    <!-- Document Title
    ============================================= -->
    <title><?=( (isset($GelenTitle)) ? $GelenTitle . ' - ' . setting('title') : setting('title') )?></title>

    <meta property="og:locale" content="<?=$currentLanguage?>" />
    <meta property="og:site_name" content="<?=setting('title')?>" />
    <?php if ( (_url(0)=='r') && (_url(1)) ): ?>
    <meta property="og:url" content="<?=( (isset($GelenUrl)) ? $GelenUrl : site_url('r') )?>" />
    <meta property="og:type" content="article" />
    <meta property="og:title" content="<?=( (isset($GelenTitle)) ? $GelenTitle . ' - ' . setting('title') : setting('title') . ' Blog' )?>" />
    <meta property="og:description" content="<?= (isset($GelenDescription)) ? $GelenDescription : setting('description_' . $selectedLanguage) ?>" />
    <meta property="og:image" content="<?= (isset($GelenImage)) ? $GelenImage : setting('outdoor_image') ?>">
    <meta property="og:image:type" content="image/png">
    <?php else: ?>  
    <meta property="og:title" content="<?=( (isset($GelenTitle)) ? $GelenTitle . ' - ' . setting('title') : setting('title') )?>" />
    <meta property="og:url" content="<?=site_url()?>" />
    <?php endif; ?>

    <!-- Twitter Card metadata -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?= isset($GelenTitle) ? $GelenTitle . ' - ' . setting('title') : setting('title') ?>">
    <meta name="twitter:description" content="<?= isset($GelenDescription) ? $GelenDescription : setting('description_' . $selectedLanguage) ?>">
    <meta name="twitter:image" content="<?= isset($GelenImage) ? $GelenImage : setting('outdoor_image') ?>">

    <?php
    $googleTag = getenv('GOOGLE_TAG') ?: ($_ENV['GOOGLE_TAG'] ?? null);
    $recaptchaSiteKey = getenv('RECAPTCHA_SITE_KEY') ?: ($_ENV['RECAPTCHA_SITE_KEY'] ?? null);
    ?>

    <!-- Google tag (gtag.js) -->
    <?php if (!empty($googleTag)): ?>
        <script async src="https://www.googletagmanager.com/gtag/js?id=<?= htmlspecialchars($googleTag, ENT_QUOTES, 'UTF-8') ?>"></script>
        <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());

        gtag('config', '<?= htmlspecialchars($googleTag, ENT_QUOTES, 'UTF-8') ?>');
        </script>
    <?php endif; ?>

    <!-- reCAPTCHA API -->
    <?php if (!empty($recaptchaSiteKey)): ?>
        <script src="https://www.google.com/recaptcha/api.js?render=<?= htmlspecialchars($recaptchaSiteKey, ENT_QUOTES, 'UTF-8') ?>"></script>
    <?php endif; ?>

    <meta name="robots" content="<?= setting('meta_robots') ?: 'index, follow' ?>">
    <meta name="googlebot" content="<?= setting('meta_googlebot') ?: 'index, follow' ?>">

    <?php if ($jsonLd = setting('jsonld')): ?>
    <script type="application/ld+json">
        <?= html_entity_decode($jsonLd) ?>
    </script>
    <?php endif; ?>

</head>

<body class="stretched">
