<script>
function showResult(str) {
  let searchBox = document.getElementById("title");
  let liveSearch = document.getElementById("livesearch");
  let loader = document.getElementById("search-loader");

  if (str.length == 0) {
    liveSearch.innerHTML = "";
    liveSearch.style.display = "none";
    loader.style.display = "none";
    return;
  }

  // Loader'ı göster
  liveSearch.style.display = "none";
  loader.style.display = "block";

  let xmlhttp = new XMLHttpRequest();
  xmlhttp.onreadystatechange = function() {
    if (this.readyState == 4 && this.status == 200) {
      loader.style.display = "none"; // Loader'ı gizle
      if (this.responseText.trim() !== "") {
        liveSearch.innerHTML = this.responseText;
        liveSearch.style.display = "block"; // Listeyi aç
      } else {
        liveSearch.style.display = "none";
      }
    }
  };
  xmlhttp.open("GET", "<?=site_url('ajax/support')?>?q=" + encodeURIComponent(str), true);
  xmlhttp.send();
}
</script>

<?php if (!(isset($BUYElogin))): ?>
  <p><?= _('To submit a support request, please') ?> <a href="<?= site_url('login') ?>"><?= _('log in') ?></a> <?= _('or') ?> <a href="<?= site_url('register') ?>"><?= _('sign up') ?></a>.</p>
<?php else: ?>
  <?php if (isset($errormsg)) echo $errormsg; ?>
  <form action="" method="post" id="check_frmm_support" onSubmit="return check_frmm_support()" name="support">
    <input type="hidden" name="token" value="<?= $_SESSION['token'] ?>">
    <div class="form-group row">
      <div class="col-sm-12">
        <input type="text" class="form-control form-control-lg" id="title" name="spt_baslik"
          placeholder="<?= _('Enter a title (e.g., Connection Problem, Payment Issue)') ?>"
          onkeyup="showResult(this.value)">

        <!-- Buraya liste formatında sonuçlar gelecek -->
        <div id="livesearch-container">
          <div id="search-loader">
              <div class="css3-spinner" style="--cnvs-loader-color:var(--cnvs-themecolor);">
								<div class="css3-spinner-ball-scale-multiple">
									<div></div>
									<div></div>
									<div></div>
								</div>
							</div>
          </div>
          <div id="livesearch"></div>
        </div>
      </div>
    </div>
    <div class="form-group row">
      <div class="col-sm-12">
        <textarea class="form-control form-control-lg" id="message" name="spt_metin" placeholder="<?= _('Please describe your issue in detail') ?>" rows="5"></textarea>
      </div>
    </div>
    <div class="form-group row">
      <div class="col-sm-6">
        <select name="spt_onem" class="form-control">
          <option value="0"><?= _('Normal') ?></option>
          <option value="1"><?= _('Important') ?></option>
          <option value="2"><?= _('Very Important') ?></option>
        </select>
      </div>
      <div class="col-sm-6">
        <label>
          <input type="checkbox" name="spt_public" id="public" checked> <?= _('Visible to everyone') ?>
        </label>
      </div>
    </div>
    <div class="form-group row">
      <div class="col-sm-12">
        <button type="submit" name="yenietiket" class="btn btn-primary"><i class="fa fa-question-circle"></i> <?= _('Create Ticket') ?></button>
      </div>
    </div>
  </form>
  <hr>
  <p><?= _('By creating a new ticket, you accept our GDPR privacy policy.') ?></p>
<?php endif; ?>
