		<!-- Footer
		============================================= -->
		<footer id="footer" class="dark" style="background: url('<?= (setting('footer_bg_image')!==null) ? setting('footer_bg_image') : public_url('images/footer-bg.jpg') ?>') repeat; background-size: cover;">
			<div class="container">
				<!-- Footer Widgets
				============================================= -->
				<div class="footer-widgets-wrap">

					<div class="row col-mb-50">
						<div class="col-md-8">
							<div class="widget">

								<img src="<?= setting('logo_dark') ?: setting('logo') ?>" alt="<?=setting('title')?>" class="alignleft" height="50px" style="margin-top: 8px; padding-right: 18px; border-right: 1px solid #4A4A4A;">

								<p><?=strip_tags(htmlspecialchars_decode(setting('footer_about_text_' . $selectedLanguage)), '<strong><em><br><a>')?></p>

								<div class="line" style="margin: 30px 0;"></div>

								<div class="row col-mb-30">
									<?php
									$footerMenu1 = get_menu(setting('footer_menu1_' . $selectedLanguage));
									$footerMenu2 = get_menu(setting('footer_menu2_' . $selectedLanguage));
									$footerBottommenu = get_menu(setting('footer_bottommenu_' . $selectedLanguage));
									?>

									<div class="col-6 col-lg-4 widget_links"> <!-- MENU 1 -->
									  <?php if (!empty($footerMenu1)): ?>
										<h5><?= setting('footer_menu1_title_' . $selectedLanguage) ?></h5>
									    <ul>
									      <?php foreach ($footerMenu1 as $item): ?>
									        <li><a href="<?= htmlspecialchars($item['url']) ?>"><?= htmlspecialchars($item['title']) ?></a></li>
									      <?php endforeach; ?>
									    </ul>
									  <?php endif; ?>
									</div>

									<div class="col-6 col-lg-4 widget_links"> <!-- MENU 2 -->
									  <?php if (!empty($footerMenu2)): ?>
										<h5><?= setting('footer_menu2_title_' . $selectedLanguage) ?></h5>
									    <ul>
									      <?php foreach ($footerMenu2 as $item): ?>
									        <li><a href="<?= htmlspecialchars($item['url']) ?>"><?= htmlspecialchars($item['title']) ?></a></li>
									      <?php endforeach; ?>
									    </ul>
									  <?php endif; ?>
									</div>

									<div class="col-12 col-lg-4 widget_links"> <!-- MENU 3 -->
									  <h5><?= _('Latest Posts') ?></h5>
									  <ul>
									    <?php
									    $latestPosts = $Veri->from('icerik')->select('content_baslik,content_kod')->where('content_onay=:onay AND content_lang=:lang')->order('content_id DESC LIMIT 0,3')->selectAll(['onay' => 1, 'lang' => $selectedLanguage]);
										if ($latestPosts):
									    	foreach ($latestPosts as $posted):
									    ?>
									      <li><a href="<?= site_url('r/' . $posted['content_kod']) ?>"><?= esc($posted['content_baslik']) ?></a></li>
									    <?php 
											endforeach; 
										endif;?>
									  </ul>
									</div>

								</div>

							</div>
						</div>

						<div class="col-md-4">
							<?php if (setting('footer_custom_html1_' . $selectedLanguage)!==null): ?>
							<div class="widget">
								<div class="row col-mb-30">
									<div class="col-lg-12">
										<?=setting('footer_custom_html1_' . $selectedLanguage)?>
									</div>
								</div>
							</div>
							<?php endif; ?>

							<?php if (setting('maillist_footer')==1): ?>
							<div class="widget">
							<h5><strong><?=_('Subscribe')?></strong> <?=_('to Our Newsletter')?></h5>
								<?=( (isset($emailmsg)) ? $emailmsg : null )?>
								<form action="<?=site_url()?>" method="post" class="mb-0">
								<input type="hidden" name="token" value="<?=$_SESSION['token']?>">
									<div class="input-group mx-auto">
										<div class="input-group-text"><i class="bi-envelope-plus"></i></div>
										<input type="email" name="email" class="form-control required email" placeholder="<?=_('E-mail address')?>">
										<button class="btn btn-success" name="epostaliste" type="submit"><?=_('Subscribe')?></button>
										<p><?=_('No spam. Your information is never shared.')?></p>
									</div>
								</form>
							</div>
							<?php endif; ?>

							<?php if (setting('footer_custom_html2_' . $selectedLanguage)!==null): ?>
							<div class="widget">
								<div class="row col-mb-30">
									<div class="col-lg-12">
										<?=setting('footer_custom_html2_' . $selectedLanguage)?>
									</div>
								</div>
							</div>
							<?php endif; ?>
						</div>
					</div>

				</div><!-- .footer-widgets-wrap end -->
			</div>

			<!-- Copyrights
			============================================= -->
			<div id="copyrights">
				<div class="container">

					<div class="row justify-content-between col-mb-30">
						<div class="col-12 col-lg-auto text-center text-lg-start">
							<div class="copyrights-menu copyright-links">
							<button type="button" class="btn btn-sm btn-dark body-scheme-toggle" data-bodyclass-toggle="dark" data-add-class="btn-warning" data-remove-class="btn-dark" data-add-html="<?=_('Light Mode')?>" data-remove-html="<?=_('Dark Mode')?>"><span class="visually-hidden">Dark Toggle</span></button>
							<?php if (!empty($footerBottommenu)): ?>
								<?php $total = count($footerBottommenu); $i = 0; ?>
								<?php foreach ($footerBottommenu as $item): $i++; ?>
								<a href="<?= htmlspecialchars($item['url']) ?>"><?= htmlspecialchars($item['title']) ?></a><?= $i < $total ? ' / ' : '' ?>
								<?php endforeach; ?>
							<?php endif; ?>
							</div>
							&copy; <?=setting('yil')?> <a href="<?=site_url()?>"><?=setting('title')?></a>. <?=_('All Rights Reserved')?>.
						</div>

						<div class="col-12 col-lg-auto text-center text-lg-end">
							<div class="d-flex">

							<?php 
							$socialJson = setting('social_accounts');
							$socialAccounts = [];
							if (is_string($socialJson) && !empty($socialJson)) {
								$decodedJson = html_entity_decode($socialJson);
								$decoded = json_decode($decodedJson, true);
								if (json_last_error() === JSON_ERROR_NONE && is_array($decoded)) {
									$socialAccounts = $decoded;
								}
							}
							if (!empty($socialAccounts) && is_array($socialAccounts)) {
								foreach ($socialAccounts as $item) {
									$platform = $item['platform'] ?? null;
									$username = $item['username'] ?? null;
									$title = (strlen($item['title'])>2) ? $item['title'] : $username;
									if ($platform && $username && isset($availablePlatforms[$platform])) {
										$data = $availablePlatforms[$platform];
										$url = rtrim($data['base'], '/') . '/' . ltrim($username, '/');
										echo '
										<a href="' . htmlspecialchars($url) . '" target="_blank" class="social-icon si-small text-white ' . htmlspecialchars($data['class']) . '">
											<i class="fa-brands ' . htmlspecialchars($data['icon']) . '"></i>
											<i class="fa-brands ' . htmlspecialchars($data['icon']) . '"></i>
										</a>
										';
									}
								}
							}
							?>

							</div>
						</div>
					</div>

				</div>
			</div><!-- #copyrights end -->
		</footer><!-- #footer end -->

	</div><!-- #wrapper end -->
