<?php
    $url = _url(1);
    $oku = $Blog->Oku($url);
    if (!isset($oku)):
      header('Location: ' . site_url('r'));
      exit();
    endif;
    $Blog->Hit($oku['content_id'],$oku['content_hit']);
    if ($oku):
        $Kategori = $Blog->Kategori('cat_ad,cat_kod', $oku['content_katID']);
        ?>

            <?php
            $toolMainTitle = $oku['content_baslik'];
            $toolSubTitle = _('Blog');
            $menuItems = [
            [
                'url' => 'r',
                'title' => _('Blog')
            ],
            [
                'url' => '#',
                'title' => _('Read')
            ]
            ];
            require view('static/toolbar');
            ?>

            <?php require view('static/blog/static/head') ?>   

            <div class="entry">
                <div class="grid-inner row g-0">
                    <div class="col-12">
                        <div class="entry-title">
                            <h2><?= $oku['content_baslik'] ?></h2>
                        </div>
                        <div class="entry-meta">
                            <ul>
                                <li><i class="uil uil-schedule"></i> <?= time_elapsed_string($oku['content_tarih']) ?> <?=_('ago')?></li>
                                <li><i class="uil uil-user"></i> <?= $oku['content_yazar'] ?></li>
                                <li><i class="uil uil-folder-open"></i> <a href="<?= site_url('r/c/' . $Kategori['cat_kod']) ?>"><?= $Kategori['cat_ad'] ?></a></li>
                                <li><i class="uil uil-comments-alt"></i> <?=$Yorum->YorumSay($oku['content_id'])?> <?=_('Comments')?></li>
                            </ul>
                        </div>
                        <div class="entry-image">
                            <img src="<?= $oku['content_resim'] ?>" alt="<?= $oku['content_baslik'] ?> - <?= $oku['content_yazar'] ?>">
                        </div>
                        
                        <div class="card border-default mb-4">
                            <div class="card-body py-2">
                                <div class="row align-items-center justify-content-between fs-6">
                                    <div class="col-md-auto fst-italic text-muted"><?=_('Language')?>: <?=$oku['content_lang']?><?php if (isset($oku['content_tarihRev'])): ?> | <i class="uil uil-schedule"></i> <?=_('Last update')?>: <?=time_elapsed_string($oku['content_tarihRev'])?> <?=_('ago')?><?php endif; ?></div>

                                    <div class="col-md-auto">
                                        <div class="d-flex">
                                            <div class="font-sizer" data-step="20" data-target=".entry-content">
                                                <button type="button" class="font-size-minus btn btn-outline-secondary border-contrast-200 h-bg-contrast-200 h-text-contrast-900 border-0 ms-1"><i class="bi-type" style="font-size: 12px;"></i></button>
                                                <button type="button" class="font-size-plus btn btn-outline-secondary border-contrast-200 h-bg-contrast-200 h-text-contrast-900 border-0 ms-1"><i class="bi-type" style="font-size: 20px;"></i></button>
                                            </div>

                                            <button type="button" class="font-size-plus btn btn-outline-secondary border-contrast-200 h-bg-contrast-200 h-text-contrast-900 border-0 ms-1" onclick="window.print();"><i class="bi-printer"></i></button>

                                            <button type="button" class="font-size-plus btn btn-outline-secondary border-contrast-200 h-bg-contrast-200 h-text-contrast-900 border-0 ms-1" data-scrollto="#cnvs-article-share"><i class="bi-share"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="entry-content">
                            <p><?= nl2br($oku['content_metin']) ?></p>
                        </div>

                        <!-- Tag Cloud
                        ============================================= -->
                        <div class="tagcloud mb-5">
                            <?=$Blog->EtiketVirgulsuz($oku['content_etiket'])?>
                        </div><!-- .tagcloud end -->

                        <!-- Post Single - Share
                        ============================================= -->
                        <div id="cnvs-article-share" class="card border-default my-4">
                            <div class="card-body p-3">
                                <div class="d-flex align-items-center justify-content-between">
                                    <h6 class="fs-6 fw-semibold mb-0"><?=_('Share')?>:</h6>
                                    <div class="d-flex">
                                        <a href="https://www.facebook.com/sharer/sharer.php?u=<?=site_url('r/' . $oku['content_kod'])?>" target="_blank" class="social-icon si-small text-white border-transparent rounded-circle bg-facebook" title="Facebook">
                                            <i class="fa-brands fa-facebook-f"></i>
                                            <i class="fa-brands fa-facebook-f"></i>
                                        </a>

                                        <a href="https://twitter.com/intent/tweet?text=<?=$oku['content_baslik']?>:&url=<?=site_url('r/' . $oku['content_kod'])?>" target="_blank" class="social-icon si-small text-white border-transparent rounded-circle bg-x-twitter" title="Twitter">
                                            <i class="fa-brands fa-x-twitter"></i>
                                            <i class="fa-brands fa-x-twitter"></i>
                                        </a>

                                        <a href="https://pinterest.com/pin/create/button/?url=<?=site_url('r/' . $oku['content_kod'])?>&media=<?=$oku['content_resim']?>&description=<?=$oku['content_baslik']?>" target="_blank" class="social-icon si-small text-white border-transparent rounded-circle bg-pinterest" title="Pinterest">
                                            <i class="fa-brands fa-pinterest-p"></i>
                                            <i class="fa-brands fa-pinterest-p"></i>
                                        </a>

                                        <a href="https://wa.me/?text=<?=$oku['content_baslik']?>: <?=site_url('r/' . $oku['content_kod'])?>" target="_blank" class="social-icon si-small text-white border-transparent rounded-circle bg-whatsapp" title="Whatsapp">
                                            <i class="fa-brands fa-whatsapp"></i>
                                            <i class="fa-brands fa-whatsapp"></i>
                                        </a>

                                        <a href="mailto:?subject=<?=setting('title')?>: <?=$oku['content_baslik']?>&body=<?=$oku['content_baslik']?>: <?=site_url('r/' . $oku['content_kod'])?>" class="social-icon si-small text-white border-transparent rounded-circle bg-email3 me-0" title="Mail">
                                            <i class="fa-solid fa-envelope"></i>
                                            <i class="fa-solid fa-envelope"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div><!-- Post Single - Share End -->

                        <div class="card border-default mt-5">
                            <div class="card-header">
                                <h5 class="mb-0"><?= _('Comments') ?> <span class="badge bg-secondary"><?= $Yorum->YorumSay($oku['content_id']) ?></span></h5>
                            </div>
                            <div class="card-body">
                                <?php $TumYorumlar = $Yorum->Yorumlar($oku['content_id']); ?>
                                <?php if ($TumYorumlar): ?>
                                    <?php foreach ($TumYorumlar as $row): ?>
                                        <?php $YorumKisi = $Yorum->YorumKisi($row['comment_userID']); ?>
                                        <div class="mb-4 pb-2 border-bottom">
                                            <p class="mb-1"><?= nl2br($row['comment_yorum']) ?></p>
                                            <div class="small text-muted">
                                                <a href="<?= site_url('u/' . $YorumKisi['user_kod']) ?>" target="_blank"><?= $YorumKisi['user_kod'] ?></a> - <?= $row['comment_tarih'] ?>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <p class="text-muted fst-italic"><?= _('No comments yet. Be the first to comment.') ?></p>
                                <?php endif; ?>
                            </div>
                        </div>

                        <?php if ((isset($BUYElogin)) && ($BUYElogin)): ?>
                            <div class="card border-default mt-4">
                                <div class="card-body">
                                    <form method="post" action="">
                                        <input type="hidden" name="token" value="<?= $_SESSION['token'] ?>">
                                        <input type="hidden" name="id" value="<?= $oku['content_id'] ?>">
                                        <div class="mb-3">
                                            <textarea class="form-control" name="metin" placeholder="<?= _('Your Comment') ?>" rows="3" required></textarea>
                                        </div>
                                        <button class="btn btn-warning" type="submit" name="yorumekle">
                                            <i class="fa fa-bullhorn"></i> <?= _('Post Comment') ?>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        <?php else: ?>
                            <div class="alert alert-warning mt-4" role="alert">
                                <?= _('To leave a comment, please') ?> <a href="<?= site_url('giris') ?>" class="alert-link"><?= _('log in') ?></a> <?= _('or') ?> <a href="<?= site_url('kayit') ?>" class="alert-link"><?= _('register') ?></a>.
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <?php require view('static/blog/static/foot') ?>

        <?php
    endif;