<?php
$toolMainTitle = _('Blog');
if (get('q')):
    $toolSubTitle = _('Search results for') . ': ' . get('q') . '<small> | <a href="' . site_url('r') . '">Back to all</a></small>';
else:
    $toolSubTitle = _('Our Latest News');
endif;
$menuItems = [
  [
    'url' => '#',
    'title' => _('Blog')
  ]
];
require view('static/toolbar');
?>

<?php require view('static/blog/static/head') ?>         
                        
                        <!-- Posts
                        ============================================= -->
                        <div id="posts" class="row gutter-40">

                        <?php
                            $kat = ((_url(2) && _url(1) == 'c') ? _url(2) : 0);
                            $ToplamKayit = $Blog->BlogSay($kat,$selectedLanguage);
                            $LIMITgosterimAdet = 15;
                            $SayfaNo = get('p') && is_numeric(get('p')) ? get('p') : 1;
                            $LIMITilk = ($SayfaNo - 1) * $LIMITgosterimAdet;
                            $order = 'content_tarih DESC LIMIT ' . $LIMITilk . ', ' . $LIMITgosterimAdet;
                            $TumYazilar = $Blog->TumYazilar($kat, get('q') ?: 0, $selectedLanguage, $order);

                            if ($TumYazilar):
                                foreach ($TumYazilar as $row):
                                    $Kategori = $Blog->Kategori('cat_ad,cat_kod', $row['content_katID']);
                                    ?>

                            <div class="entry col-12">
                                <div class="grid-inner row g-0">
                                    <div class="col-md-4">
                                        <div class="entry-image">
                                        <a href="<?= site_url('r/' . $row['content_kod']) ?>"><img src="<?=$row['content_resim_thumb']?>" alt="<?=$row['content_baslik']?>"></a>
                                        </div>
                                    </div>
                                    <div class="col-md-8 ps-md-4">
                                        <div class="entry-title title-sm">
                                            <h2><a href="<?= site_url('r/' . $row['content_kod']) ?>"> <?= $row['content_baslik'] ?> </a></h2>
                                        </div>
                                        <div class="entry-meta">
                                            <ul>
                                                <li><i class="uil uil-schedule"></i> <?= time_elapsed_string($row['content_tarih']) ?></li>
                                                <li><i class="uil uil-folder-open"></i> <a href="<?= site_url('r/c/' . $Kategori['cat_kod']) ?>"> <?= $Kategori['cat_ad'] ?></a></li>
                                                <li><a href="<?= site_url('r/' . $row['content_kod']) ?>"><i class="uil uil-comments-alt"></i> <?=$Yorum->YorumSay($row['content_id'])?></a></li>
                                            </ul>
                                        </div>
                                        <div class="entry-content">
                                            <p><?= mb_substr(strip_tags($row['content_metin']), 0, 200) ?>...</p>
                                            <a href="<?= site_url('r/' . $row['content_kod']) ?>" class="more-link">Read More</a>
                                        </div>
                                    </div>
                                </div>
                            </div>

                                    <?php
                                endforeach;
                            endif;
                            ?>

                        </div><!-- #posts end -->

                        <!-- Pager
                        ============================================= -->
                        <div class="d-flex justify-content-between mt-5">
                            <?php require view('static/blog/static/pagination') ?>
                        </div>
                        <!-- .pager end -->

<?php require view('static/blog/static/foot') ?>