<?php
// Cache dosyası yolu
define('SETTINGS_CACHE_FILE', __DIR__ . '/../storage/cache/app_settings.php');

// Cache süresi (saniye cinsinden) - 5 dakika
define('SETTINGS_CACHE_LIFETIME', 300);

// Eğer cache geçerliyse, cache’ten yükle
if (file_exists(SETTINGS_CACHE_FILE) && (time() - filemtime(SETTINGS_CACHE_FILE)) < SETTINGS_CACHE_LIFETIME) {
    $settings = include SETTINGS_CACHE_FILE;
    return;
}

$rows = $Veri->from('app_settings')->select('setting_key, setting_value')->where('setting_valid=:valid')->order('id ASC')->selectAll(['valid' => 1]);

$settings = [];
if (isset($rows)){
    foreach ($rows as $row) {
        $settings[$row['setting_key']] = $row['setting_value'];
    }
}

// Cache dosyasını yaz
$export = var_export($settings, true);
file_put_contents(SETTINGS_CACHE_FILE, "<?php\nreturn {$export};");