<?php
declare(strict_types=1);

## Oturum başlatma ve çıktı tamponlama
$session_lifetime = 3600 * 24 * 30; // 30 gün
session_name('secure_session'); // Özel session adı
ini_set('session.gc_maxlifetime', (string) $session_lifetime);
session_set_cookie_params([
    'lifetime' => $session_lifetime,
    'path' => '/',
    'domain' => $_SERVER['HTTP_HOST'] ?? '',
    'secure' => isset($_SERVER['HTTPS']), // HTTPS varsa Secure flag ekle
    'httponly' => true, // XSS saldırılarına karşı güvenlik artır
    'samesite' => 'Strict', // CSRF saldırılarına karşı koruma
]);
session_start();
ob_start();

## Composer autoload yükleme
require_once __DIR__ . '/../vendor/autoload.php';

## .env yükleme işlemleri
$dotenvPath = dirname(__DIR__);
if (file_exists($dotenvPath . '/.env')) {
    $dotenv = Dotenv\Dotenv::createImmutable($dotenvPath);
    $dotenv->load();
} else {
    error_log(".env dosyası bulunamadı: $dotenvPath/.env");
    header("Location: /error"); // Özel hata sayfasına yönlendirme
    exit;
}

## Global ayarları yükle
$config = require __DIR__ . '/config.php';

## Veritabanı bağlantısını başlat
$Veri = new App\Classes\Database\Veri();

require __DIR__ . '/settings.php';

## Helper dosyalarını yükle
foreach (glob(__DIR__ . '/helper/*.php') as $helperFile) {
    require_once $helperFile;
}

require __DIR__ . '/details.php';

## CSRF güvenliği kontrolü
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $headers = getallheaders();
    $referer = $_SERVER['HTTP_REFERER'] ?? '';
    $host = $_SERVER['HTTP_HOST'];

    if (
        (!isset($_POST['token']) || $_POST['token'] !== ($_SESSION['token'] ?? '')) &&
        !isset($_SESSION['tokenMuaf']) &&
        (!isset($headers['Origin']) || parse_url($headers['Origin'], PHP_URL_HOST) !== $host) &&
        (!isset($referer) || parse_url($referer, PHP_URL_HOST) !== $host)
    ) {
        error_log("CSRF güvenlik ihlali algılandı.");
        header('Location: /csrf');
        exit;
    }

    unset($_SESSION['tokenMuaf']);
}

## Yeni CSRF token üretme
$_SESSION['token'] = bin2hex(random_bytes(30));

## Gizli Anahtar (Yalnızca .env'den alınmalı)
$globalSecretKey = getenv('GLOBAL_SECRET_KEY') ?: 'default_secret_key';
