<?php

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

function mailGo($alici, $aliciCC, $konu, $mesaj) {
    header('Content-Type: text/html; charset=utf-8');
    
    try {
        $phpmailer = new PHPMailer(true);
        $phpmailer->isSMTP();
        $phpmailer->SMTPDebug = 0;
        $phpmailer->Host = getenv('SMTP_ADDRESS');
        $phpmailer->Port = getenv('SMTP_PORT');
        $phpmailer->SMTPAuth = true;
        $phpmailer->SMTPSecure = getenv('SMTP_SECURE');
        $phpmailer->SMTPAutoTLS = true;
        
        $phpmailer->Username = getenv('SMTP_USERNAME');
        $phpmailer->Password = getenv('SMTP_PASSWORD');
        
        $phpmailer->setFrom(getenv('SMTP_EMAIL'), getenv('SITE_TITLE'));
        $phpmailer->addReplyTo(getenv('EMAIL_REPLY'), getenv('SITE_TITLE'));
        
        if (!empty($alici) && is_array($alici)) {
            foreach ($alici as $email) {
                if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
                    $phpmailer->addAddress($email);
                }
            }
        }
        
        if (!empty($aliciCC) && filter_var($aliciCC, FILTER_VALIDATE_EMAIL)) {
            $phpmailer->addCC($aliciCC);
        }
        
        $phpmailer->isHTML(true);
        $phpmailer->Subject = $konu;
        $phpmailer->Body = $mesaj;
        $phpmailer->CharSet = 'UTF-8';
        
        $phpmailer->send();
        return ['success' => 1, 'error' => ''];
    } catch (Exception $e) {
        error_log('Mail Gönderim Hatası: ' . $e->getMessage());
        return ['success' => 0, 'error' => $e->getMessage()];
    }
}

function smsGonder($alici, $mesaj) {
    try {
        $client = new SoapClient("http://soap.netgsm.com.tr:8080/Sms_webservis/SMS?wsdl");
        
        $result = $client->sms_gonder_1n([
            'username' => getenv('SMS_USERNAME'),
            'password' => getenv('SMS_PASSWORD'),
            'company' => getenv('SMS_COMPANY'),
            'header' => getenv('SMS_HEADER'),
            'msg' => $mesaj,
            'gsm' => $alici,
            'encoding' => 'TR',
            'startdate' => '',
            'stopdate' => ''
        ]);
        
        return ['success' => 1, 'response' => $result];
    } catch (Exception $e) {
        error_log('SMS Gönderim Hatası: ' . $e->getMessage());
        return ['success' => 0, 'error' => $e->getMessage()];
    }
}