<?php

function filterUrl($str) {
    return htmlspecialchars(trim($str), ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
}

function getURL($name) {
    if (!isset($_GET[$name])) {
        return false;
    }
    return is_array($_GET[$name])
        ? array_map('filterUrl', $_GET[$name])
        : filterUrl($_GET[$name]);
}

function kisalt($kelime, $str = 10) {
    return mb_strlen($kelime, 'UTF-8') > $str
        ? mb_substr($kelime, 0, $str, 'UTF-8') . '..'
        : $kelime;
}

function sendRequest($site_name, $send_xml, $header_type) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $site_name);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $send_xml);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $header_type);
    curl_setopt($ch, CURLOPT_HEADER, 0);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
    curl_setopt($ch, CURLOPT_TIMEOUT, 120);

    $SMSresult = curl_exec($ch);
    if (curl_errno($ch)) {
        error_log('CURL error: ' . curl_error($ch));
        return false;
    }
    curl_close($ch);
    return $SMSresult;
}

function tckimlik($tckimlik) {
    if (!preg_match('/^\d{11}$/', $tckimlik)) {
        return false;
    }

    $olmaz = ['11111111110','22222222220','33333333330','44444444440','55555555550',
              '66666666660','77777777770','88888888880','99999999990'];
    if (in_array($tckimlik, $olmaz)) {
        return false;
    }

    $ilkt = array_sum(array_map('intval', str_split(substr($tckimlik, 0, 9), 2))) * 7;
    $sont = array_sum(array_map('intval', str_split(substr($tckimlik, 1, 8), 2)));

    if (($ilkt - $sont) % 10 !== (int) $tckimlik[9]) {
        return false;
    }

    if (array_sum(str_split(substr($tckimlik, 0, 10))) % 10 !== (int) $tckimlik[10]) {
        return false;
    }
    return true;
}

function encryptData($data, $secretKey = null) {
    if ($secretKey === null) {
        $secretKey = $_ENV['GLOBAL_SECRET_KEY'];
    }
    $encryptMethod = 'AES-256-CBC';
    $ivLength = openssl_cipher_iv_length($encryptMethod);
    $iv = openssl_random_pseudo_bytes($ivLength);
    $encryptedData = openssl_encrypt($data, $encryptMethod, $secretKey, 0, $iv);

    if ($encryptedData === false) {
        error_log('Encryption failed: ' . openssl_error_string());
        return false;
    }
    return base64_encode($iv . $encryptedData);
}

function decryptData($encryptedData, $secretKey = null) {
    if ($secretKey === null) {
        $secretKey = $_ENV['GLOBAL_SECRET_KEY'];
    }
    $encryptMethod = 'AES-256-CBC';
    $data = base64_decode($encryptedData);
    $ivLength = openssl_cipher_iv_length($encryptMethod);
    $iv = substr($data, 0, $ivLength);
    $encryptedText = substr($data, $ivLength);

    $decryptedText = openssl_decrypt($encryptedText, $encryptMethod, $secretKey, 0, $iv);
    if ($decryptedText === false) {
        error_log('Decryption failed: ' . openssl_error_string());
        return false;
    }
    return $decryptedText;
}

function money($amount, $currencyCode = 'usd') {
    $currencyFormats = [
        'usd' => '$%s', 'cad' => 'CA$%s', 'brl' => 'R$%s', 'mxn' => 'MX$%s',
        'eur' => '€%s', 'gbp' => '£%s', 'sek' => 'kr %s', 'zar' => 'R %s',
        'pln' => 'zł %s', 'egp' => 'E£ %s', 'try' => '₺ %s', 'sar' => 'SAR %s',
        'aed' => 'AED %s', 'inr' => '₹ %s', 'sgd' => 'S$ %s', 'aud' => 'A$ %s',
        'jpy' => '¥%s'
    ];

    return sprintf($currencyFormats[strtolower($currencyCode)] ?? '$%s', number_format($amount, 2, ',', '.'));
}

function recaptcha($recaptcha)
{
    $recaptcha_secretkey = getenv('RECAPTCHA_SECRET_KEY') ?: ($_ENV['RECAPTCHA_SECRET_KEY'] ?? null);

    if (!$recaptcha_secretkey) {
        error_log("ReCaptcha Secret Key is missing.");
        return false; // Eğer anahtar eksikse doğrulamayı başarısız say.
    }

    if (!$recaptcha) {
        error_log("ReCaptcha response is empty.");
        return false; // Kullanıcı yanıt vermemişse başarısız say.
    }

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => 'https://www.google.com/recaptcha/api/siteverify',
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => http_build_query([
            'secret' => $recaptcha_secretkey,
            'response' => $recaptcha
        ]),
        CURLOPT_RETURNTRANSFER => true
    ]);

    $output = curl_exec($ch);

    if ($output === false) {
        error_log("cURL Error: " . curl_error($ch));
        curl_close($ch);
        return false;
    }

    curl_close($ch);

    $result = json_decode($output, true);

    return !empty($result['success']) && $result['success'] === true;
}

function time_elapsed_string($datetime, $full = false) {
    $now = new DateTime;
    $ago = new DateTime($datetime);
    $diff = $now->diff($ago);

    // Haftaları ayrı bir değişkende tutalım
    $weeks = floor($diff->d / 7);
    $diff->d -= $weeks * 7;

    $string = array(
        'y' => 'yr',
        'm' => 'mnt',
        'w' => 'wk',
        'd' => 'day',
        'h' => 'hr',
        'i' => 'mn',
        's' => 'sn',
    );

    $diffArray = [
        'y' => $diff->y,
        'm' => $diff->m,
        'w' => $weeks, // Hesaplanan hafta değerini burada kullanıyoruz
        'd' => $diff->d,
        'h' => $diff->h,
        'i' => $diff->i,
        's' => $diff->s,
    ];

    foreach ($string as $k => &$v) {
        if ($diffArray[$k]) {
            $v = $diffArray[$k] . ' ' . $v;
        } else {
            unset($string[$k]);
        }
    }

    if (!$full) {
        $string = array_slice($string, 0, 1);
    }

    return $string ? implode(', ', $string) : 'now';
}


function permalink($str, $options = array()) {
    $str = mb_convert_encoding((string)$str, 'UTF-8', mb_list_encodings());
    $defaults = array(
        'delimiter' => '-',
        'limit' => null,
        'lowercase' => true,
        'replacements' => array(),
        'transliterate' => true
    );
    $options = array_merge($defaults, $options);

    // Yer değiştirmeleri işle
    foreach ($options['replacements'] as $key => $value) {
        $str = str_replace($key, $value, $str);
    }

    // Karakter haritasını uygula
    if ($options['transliterate']) {
        $char_map = array(
          // Latin
          'À' => 'A', 'Á' => 'A', 'Â' => 'A', 'Ã' => 'A', 'Ä' => 'A', 'Å' => 'A', 'Æ' => 'AE', 'Ç' => 'C',
          'È' => 'E', 'É' => 'E', 'Ê' => 'E', 'Ë' => 'E', 'Ì' => 'I', 'Í' => 'I', 'Î' => 'I', 'Ï' => 'I',
          'Ð' => 'D', 'Ñ' => 'N', 'Ò' => 'O', 'Ó' => 'O', 'Ô' => 'O', 'Õ' => 'O', 'Ö' => 'O', 'Ő' => 'O',
          'Ø' => 'O', 'Ù' => 'U', 'Ú' => 'U', 'Û' => 'U', 'Ü' => 'U', 'Ű' => 'U', 'Ý' => 'Y', 'Þ' => 'TH',
          'ß' => 'ss',
          'à' => 'a', 'á' => 'a', 'â' => 'a', 'ã' => 'a', 'ä' => 'a', 'å' => 'a', 'æ' => 'ae', 'ç' => 'c',
          'è' => 'e', 'é' => 'e', 'ê' => 'e', 'ë' => 'e', 'ì' => 'i', 'í' => 'i', 'î' => 'i', 'ï' => 'i',
          'ð' => 'd', 'ñ' => 'n', 'ò' => 'o', 'ó' => 'o', 'ô' => 'o', 'õ' => 'o', 'ö' => 'o', 'ő' => 'o',
          'ø' => 'o', 'ù' => 'u', 'ú' => 'u', 'û' => 'u', 'ü' => 'u', 'ű' => 'u', 'ý' => 'y', 'þ' => 'th',
          'ÿ' => 'y',
          // Latin symbols
          '©' => '(c)',
          // Greek
          'Α' => 'A', 'Β' => 'B', 'Γ' => 'G', 'Δ' => 'D', 'Ε' => 'E', 'Ζ' => 'Z', 'Η' => 'H', 'Θ' => '8',
          'Ι' => 'I', 'Κ' => 'K', 'Λ' => 'L', 'Μ' => 'M', 'Ν' => 'N', 'Ξ' => '3', 'Ο' => 'O', 'Π' => 'P',
          'Ρ' => 'R', 'Σ' => 'S', 'Τ' => 'T', 'Υ' => 'Y', 'Φ' => 'F', 'Χ' => 'X', 'Ψ' => 'PS', 'Ω' => 'W',
          'Ά' => 'A', 'Έ' => 'E', 'Ί' => 'I', 'Ό' => 'O', 'Ύ' => 'Y', 'Ή' => 'H', 'Ώ' => 'W', 'Ϊ' => 'I',
          'Ϋ' => 'Y',
          'α' => 'a', 'β' => 'b', 'γ' => 'g', 'δ' => 'd', 'ε' => 'e', 'ζ' => 'z', 'η' => 'h', 'θ' => '8',
          'ι' => 'i', 'κ' => 'k', 'λ' => 'l', 'μ' => 'm', 'ν' => 'n', 'ξ' => '3', 'ο' => 'o', 'π' => 'p',
          'ρ' => 'r', 'σ' => 's', 'τ' => 't', 'υ' => 'y', 'φ' => 'f', 'χ' => 'x', 'ψ' => 'ps', 'ω' => 'w',
          'ά' => 'a', 'έ' => 'e', 'ί' => 'i', 'ό' => 'o', 'ύ' => 'y', 'ή' => 'h', 'ώ' => 'w', 'ς' => 's',
          'ϊ' => 'i', 'ΰ' => 'y', 'ϋ' => 'y', 'ΐ' => 'i',
          // Turkish
          'Ş' => 'S', 'İ' => 'I', 'Ç' => 'C', 'Ü' => 'U', 'Ö' => 'O', 'Ğ' => 'G',
          'ş' => 's', 'ı' => 'i', 'ç' => 'c', 'ü' => 'u', 'ö' => 'o', 'ğ' => 'g',
          // Russian
          'А' => 'A', 'Б' => 'B', 'В' => 'V', 'Г' => 'G', 'Д' => 'D', 'Е' => 'E', 'Ё' => 'Yo', 'Ж' => 'Zh',
          'З' => 'Z', 'И' => 'I', 'Й' => 'J', 'К' => 'K', 'Л' => 'L', 'М' => 'M', 'Н' => 'N', 'О' => 'O',
          'П' => 'P', 'Р' => 'R', 'С' => 'S', 'Т' => 'T', 'У' => 'U', 'Ф' => 'F', 'Х' => 'H', 'Ц' => 'C',
          'Ч' => 'Ch', 'Ш' => 'Sh', 'Щ' => 'Sh', 'Ъ' => '', 'Ы' => 'Y', 'Ь' => '', 'Э' => 'E', 'Ю' => 'Yu',
          'Я' => 'Ya',
          'а' => 'a', 'б' => 'b', 'в' => 'v', 'г' => 'g', 'д' => 'd', 'е' => 'e', 'ё' => 'yo', 'ж' => 'zh',
          'з' => 'z', 'и' => 'i', 'й' => 'j', 'к' => 'k', 'л' => 'l', 'м' => 'm', 'н' => 'n', 'о' => 'o',
          'п' => 'p', 'р' => 'r', 'с' => 's', 'т' => 't', 'у' => 'u', 'ф' => 'f', 'х' => 'h', 'ц' => 'c',
          'ч' => 'ch', 'ш' => 'sh', 'щ' => 'sh', 'ъ' => '', 'ы' => 'y', 'ь' => '', 'э' => 'e', 'ю' => 'yu',
          'я' => 'ya',
          // Ukrainian
          'Є' => 'Ye', 'І' => 'I', 'Ї' => 'Yi', 'Ґ' => 'G',
          'є' => 'ye', 'і' => 'i', 'ї' => 'yi', 'ґ' => 'g',
          // Czech
          'Č' => 'C', 'Ď' => 'D', 'Ě' => 'E', 'Ň' => 'N', 'Ř' => 'R', 'Š' => 'S', 'Ť' => 'T', 'Ů' => 'U',
          'Ž' => 'Z',
          'č' => 'c', 'ď' => 'd', 'ě' => 'e', 'ň' => 'n', 'ř' => 'r', 'š' => 's', 'ť' => 't', 'ů' => 'u',
          'ž' => 'z',
          // Polish
          'Ą' => 'A', 'Ć' => 'C', 'Ę' => 'e', 'Ł' => 'L', 'Ń' => 'N', 'Ó' => 'o', 'Ś' => 'S', 'Ź' => 'Z',
          'Ż' => 'Z',
          'ą' => 'a', 'ć' => 'c', 'ę' => 'e', 'ł' => 'l', 'ń' => 'n', 'ó' => 'o', 'ś' => 's', 'ź' => 'z',
          'ż' => 'z',
          // Latvian
          'Ā' => 'A', 'Č' => 'C', 'Ē' => 'E', 'Ģ' => 'G', 'Ī' => 'i', 'Ķ' => 'k', 'Ļ' => 'L', 'Ņ' => 'N',
          'Š' => 'S', 'Ū' => 'u', 'Ž' => 'Z',
          'ā' => 'a', 'č' => 'c', 'ē' => 'e', 'ģ' => 'g', 'ī' => 'i', 'ķ' => 'k', 'ļ' => 'l', 'ņ' => 'n',
          'š' => 's', 'ū' => 'u', 'ž' => 'z'
        );
        $str = strtr($str, $char_map);
    }

    // URL dostu bir dizeye dönüştür
    $str = preg_replace('/[^\p{L}\p{Nd}]+/u', $options['delimiter'], $str);
    $str = preg_replace('/(' . preg_quote($options['delimiter'], '/') . '){2,}/', '$1', $str);
    $str = mb_substr($str, 0, ($options['limit'] ? $options['limit'] : mb_strlen($str, 'UTF-8')), 'UTF-8');
    $str = trim($str, $options['delimiter']);

    return $options['lowercase'] ? mb_strtolower($str, 'UTF-8') : $str;
}

function random_string($length) {
  $key = '';
  $keys = array_merge(range(0, 9), range('a', 'z'));
  for ($i = 0; $i < $length; $i++) {
      $key .= $keys[array_rand($keys)];
  }
  return $key;
}

function get_menu($key = null) {
    if (!$key) {
        return []; // veya null, ya da hata mesajı
    }

    $json = setting($key);
    return json_decode($json ?: '{}', true);
}

function esc($str) {
    return htmlspecialchars($str, ENT_QUOTES, 'UTF-8');
}