<?php

function post($name, $default = '') {
    if (!isset($_POST[$name])) {
        return $default;
    }
    
    if (is_array($_POST[$name])) {
        return array_map(function($item) {
            return htmlspecialchars(trim($item), ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
        }, $_POST[$name]);
    }
    
    return htmlspecialchars(trim($_POST[$name]), ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
}

function get($name, $default = '') {
    if (!isset($_GET[$name])) {
        return $default;
    }
    
    if (is_array($_GET[$name])) {
        return array_map(function($item) {
            return htmlspecialchars(trim($item), ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
        }, $_GET[$name]);
    }
    
    return htmlspecialchars(trim($_GET[$name]), ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
}