<?php
function controller($controllerName){
    $controllerName = strtolower($controllerName);
    return PATH . '/app/controller/' . $controllerName . '.php';
}

function view($viewName){
    return PATH . '/app/view/' . setting('theme') . '/' . $viewName . '.php';
}

function _url($index)
{
    global $_urlParts, $supportedLanguages;

    // Çoklu dil desteği aktif mi?
    $multilingual = setting('multilingual') == 1;

    // Dil kontrolünden muaf olan bölümler
    $excludedRoutes = getExcludedRoutes();

    // Eğer URL'nin ilk segmenti dil kontrolünden muafsa, index kaydırma yapmadan döndür
    if (!empty($_urlParts[0]) && in_array($_urlParts[0], $excludedRoutes)) {
        return $_urlParts[$index] ?? false;
    }

    // Eğer çoklu dil aktifse ve URL'nin ilk segmenti dil koduysa
    if ($multilingual && !empty($_urlParts[0]) && in_array($_urlParts[0], $supportedLanguages)) {
        // Eğer ikinci segment dil muafiyeti olan bir bölüme aitse, index kaydırmayı iptal et
        if (!empty($_urlParts[1]) && in_array($_urlParts[1], $excludedRoutes)) {
            return $_urlParts[$index + 1] ?? false; // Dili atlayıp doğrudan ikinci segmenti al
        }

        // Dil kodu varsa index'i bir kaydır
        $index += 1;
    }

    // Belirtilen index'e karşılık gelen değeri döndür
    return $_urlParts[$index] ?? false;
}

function setting(?string $key, $default = null) {
    if (!$key) return $default;

    static $settings = null;

    if ($settings === null) {
        $cacheFile = __DIR__ . '/../../storage/cache/app_settings.php';

        if (file_exists($cacheFile)) {
            $settings = include $cacheFile;

            if (!is_array($settings)) {
                $settings = [];
            }
        } else {
            $settings = [];
        }
    }

    return $settings[$key] ?? $default;
}

function save_settings(array $settings, bool $clearCache = true): bool
{
    global $Veri;

    $user_id = $BUYEid ?? 1;
    $user_ip = $_SERVER['REMOTE_ADDR'] ?? '127.0.0.1';

    foreach ($settings as $key => $val) {
        $existing = $Veri->from('app_settings')
            ->select('id')
            ->where('setting_key=:key')
            ->selectOne(['key' => $key]);

        if ($existing) {
            $Veri->update('app_settings')
                ->set('
                    setting_value=:setting_value,
                    updated_by=:updated_by,
                    updated_ip=:updated_ip,
                    updated_at=:updated_at
                ')
                ->where('id=:id')
                ->updateOne([
                    'id' => $existing['id'],
                    'setting_value' => $val,
                    'updated_by' => $user_id,
                    'updated_ip' => $user_ip,
                    'updated_at' => date('Y-m-d H:i:s')
                ]);
        } else {
            $Veri->insert('app_settings')
                ->set('
                    setting_key=:setting_key,
                    setting_value=:setting_value,
                    setting_type=:setting_type,
                    created_by=:created_by,
                    created_ip=:created_ip,
                    updated_by=:updated_by,
                    updated_ip=:updated_ip,
                    created_at=:created_at,
                    updated_at=:updated_at
                ')
                ->insertOne([
                    'setting_key'   => $key,
                    'setting_value' => $val,
                    'setting_type'  => 'string',
                    'created_by'    => $user_id,
                    'created_ip'    => $user_ip,
                    'updated_by'    => $user_id,
                    'updated_ip'    => $user_ip,
                    'created_at'    => date('Y-m-d H:i:s'),
                    'updated_at'    => date('Y-m-d H:i:s')
                ]);
        }
    }

    if ($clearCache) {
        $cacheFile = realpath(__DIR__ . '/../../storage/cache/app_settings.php');
        if ($cacheFile && file_exists($cacheFile)) {
            unlink($cacheFile);
        }
    }

    return true;
}