<?php

// Kullanıcı girişi kontrolü
if (!empty($_COOKIE['login'])) {
    $user_email = filter_var(decryptData($_COOKIE['user_email'] ?? ''), FILTER_SANITIZE_EMAIL);
    $user_id = filter_var(decryptData($_COOKIE['user_id'] ?? ''), FILTER_SANITIZE_NUMBER_INT);

    $Uye = new App\Classes\Uyelik\Uyeler();
    $uyeAl = $Uye->Ben($user_id, $user_email);

    if (empty($uyeAl)) {
        $uyeAl = 'Kişi bulunamadı.';
    } else {
        // Kullanıcı bilgilerini değişkenlere atama
        $BUYEid = $uyeAl['user_id'];
        $BUYEad = $uyeAl['user_ad'];
        $BUYEsoyad = $uyeAl['user_soyad'];
        $BUYEemail = $uyeAl['user_email'];
        $BUYEtelefon = $uyeAl['user_telefon'];
        $BUYEtckn = $uyeAl['user_tckn'];
        $BUYEpasaport = $uyeAl['user_pasaport'];
        $BUYEyetki = $uyeAl['user_yetki'];
        $BUYEonay = $uyeAl['user_onay'];
        $BUYEtarih = $uyeAl['user_tarih'];
        $BUYEkod = $uyeAl['user_kod'];
        $BUYEresim = !empty($uyeAl['user_resim']) ? $uyeAl['user_resim'] : public_url('images/nophoto.jpg');
        $BUYEcinsiyet = $uyeAl['user_cinsiyet'];
        $BUYEdt = $uyeAl['user_dt'];
        $BUYEmailPromo = $uyeAl['user_mailPromo'];
        $BUYEsmsPromo = $uyeAl['user_smsPromo'];
        $BUYEmailReport = $uyeAl['user_mailReport'];
        $BUYEsmsReport = $uyeAl['user_smsReport'];
        $BUYEadres = $uyeAl['user_adres'];
        $BUYElogin = true;

        // Kullanıcının onayı yoksa sistemden çıkış yaptır
        if ($BUYEonay == 0) {
            $Log = new App\Classes\Uyelik\Log();
            $Log->Add('Çıkış', 'Yasaklı olduğun için sistemden çıkarıldın.');
            
            setcookie("login", '', time() - 3600, '/', '', true, true, ['samesite' => 'Strict']);
            setcookie("user_id", '', time() - 3600, '/', '', true, true, ['samesite' => 'Strict']);
            setcookie("user_email", '', time() - 3600, '/', '', true, true, ['samesite' => 'Strict']);
            
            header('Location: ' . site_url('yasakli'));
            exit;
        }
    }
}

// 🌐 Global Timezone Configuration
$globalTimezone = setting('global_timezone') ?? 'UTC';
$_url = getURL('url');
$_urlParts = array_filter(explode('/', $_url));

$skipTimezoneScript = false;
if ((isset($_urlParts[0]))&&(in_array($_urlParts[0], getExcludedRoutes()))) {
    $skipTimezoneScript = true;
}

if (!$skipTimezoneScript && in_array($globalTimezone, ['UTC', '', null])) {
    // UTC seçilmişse veya ayarlanmadıysa, kullanıcı timezone'u için JS kullanılacak
    date_default_timezone_set('UTC'); // Sistem işlemleri için UTC sabit kalır

    echo "<script>
    (function() {
      try {
        if (!document.cookie.includes('user_timezone')) {
          var tz = Intl.DateTimeFormat().resolvedOptions().timeZone;
          document.cookie = 'user_timezone=' + tz + ';path=/;SameSite=Strict;Secure';
        }
      } catch (e) {
        console.warn('Timezone detection failed:', e);
      }
    })();
    </script>";
} else {
    // Belirli bir timezone seçilmişse tüm site ona göre çalışır
    date_default_timezone_set($globalTimezone);
}