<?php
## LOGIN CONTROL ---- Login ( Sign In: 1/0  |  MB: 1/0 ) ----
$control = new App\Classes\Uyelik\Kontrol;
$control->Login(0);
## LOGIN CONTROL

## OPERATIONS START
$PageTitle = _('Support System'); // TO SEND A CUSTOM TITLE
## OPERATIONS END

## Load Classes
$User = new App\Classes\Uyelik\Uyeler;
$Log = new App\Classes\Uyelik\Log;
$Email = new App\Classes\Send\Email;
$Support = new App\Classes\Destek\Genel;
## Classes Loaded

## POST OPERATIONS
if (isset($_POST['yenietiket'])):
  $spt_baslik = post('spt_baslik');
  $spt_metin = post('spt_metin');
  $spt_onem = post('spt_onem');
  $spt_public = post('spt_public') ? 1 : 0;
  $spt_tarih = date('Y-m-d H:i:s');
  
  if (empty($spt_baslik) || empty($spt_metin)) : // Input validation
    $errormsg = '<div class="alert alert-danger">'._('Title or content field cannot be left empty.').'</div>';
  else:
    $ticketCreated = $Support->YeniEtiket([
      "userID" => $BUYEid,
      "baslik" => $spt_baslik,
      "metin" => $spt_metin,
      "onem" => $spt_onem,
      "tarih" => $spt_tarih,
      "public" => $spt_public
    ]);
    
    if ($ticketCreated == 1):
      $managers = $User->Tum('user_yetki>:yetki AND user_onay=:onay', 'user_id DESC', ["yetki" => 4, "onay" => 1]);
      $recipientEmails = setting('email');
      if ($managers):
        foreach($managers as $manager):
          $recipientEmails .= ',' . $manager['user_email'];
          $recipientPhones[] = $manager['user_telefon'];
        endforeach;
      endif;
      
      // EMAIL SENDING START
      $recipient = $recipientEmails;
      $subject = _('New Support Request');
      $message = _('Hello Admin, someone needs your help!') . '<br><a href="' . site_url('support') . '" target="_blank">' . _('Check open support requests now ->') . '</a>';
      $Email->Kaydet($recipient, '', $subject, $message, date('Y-m-d H:i:s'));
      // EMAIL SENDING END
      
      // SMS SENDING START
      $smsMessage = _('A new support request has arrived, check it now!');
      $smsRecipients = $recipientPhones;
      smsGonder($smsRecipients, $smsMessage);
      // SMS SENDING END
      
      $errormsg = '<div class="alert alert-success">'._('Your support request has been successfully received. Our team will get back to you soon.').'</div>';
    else:
      $errormsg = '<div class="alert alert-danger">'._('An error occurred.').'</div>';
    endif;
  endif;
elseif (isset($_POST['etiketcevap'])):
  $ANSsupportID = post('supportID');
  $ANSmetin = post('metin');
  $ANStarih = date('Y-m-d H:i:s');
  
  if (empty($ANSmetin)):
    $errormsg = '<div class="alert alert-danger">'._('Content field cannot be left empty.').'</div>';
  else:
    $replyCreated = $Support->YeniCevap([
      "userID" => $BUYEid,
      "supportID" => $ANSsupportID,
      "metin" => $ANSmetin,
      "tarih" => $ANStarih
    ]);
    
    if ($replyCreated > 0):
      $profile = $User->Kisi($replyCreated);
      if ($profile):
        if (($BUYEid != $profile['user_id']) && ($profile['user_mailReport'] == 1)):
          $recipient = $profile['user_email'];
          $subject = _('Your support request has been answered');
          $message = _('Hello') . ' ' . $profile['user_ad'] . ' ' . $profile['user_soyad'] . ',<br><br>' . _('Your support request has been answered by the Nox team. Check it now: ') . '<a href="' . site_url('support/view/' . $ANSsupportID) . '" target="_blank">' . _('See the response') . '</a>.';
          $Email->Kaydet($recipient, '', $subject, $message, date('Y-m-d H:i:s'));
        endif;
      endif;
      $errormsg = '<div class="alert alert-success">'._('Your support response has been successfully saved. Thank you.').'</div>';
    endif;
  endif;
elseif (isset($_POST['like'])):
  $ANSid = post('ansID');
  $like = $Support->Begen($ANSid,1);
  if ($like==1):
    $errormsg = '<div class="alert alert-success">' . _('We are glad you found this answer helpful') . '..</div>';
  else:
    $errormsg = '<div class="alert alert-danger">' . _('An error occured') . '.</div>';
  endif;
elseif (isset($_POST['dislike'])):
  $ANSid = post('ansID');
  $like = $Support->Begen($ANSid,0);
  if ($like==1):
    $errormsg = '<div class="alert alert-success">' . _('We are sorry this answer did not help you') . ', <a href="' . site_url('support/new') . '">' . _('open a new ticket now') . '</a>.</div>';
  else:
    $errormsg = '<div class="alert alert-danger">' . _('An error occured') . '.</div>';
  endif;
elseif (isset($_POST['close'])):
  $SPTid = post('sptID');
  $guncelle = $Support->Guncelle('spt_acik=:acik',["acik" => 0, "id" => $SPTid]);
  if ($guncelle==1):
    $errormsg = '<div class="alert alert-success">' . _('Ticket closed successfully') . '.</div>';
  else:
    $errormsg = '<div class="alert alert-danger">' . _('An error occured') . '.</div>';
  endif;
elseif (isset($_POST['open'])):
  $SPTid = post('sptID');
  $guncelle = $Support->Guncelle('spt_acik=:acik',["acik" => 1, "id" => $SPTid]);
  if ($guncelle==1):
    $errormsg = '<div class="alert alert-success">' . _('Ticket reopened successfully') . '.</div>';
    // E-POSTA GÖNDERİMİ BAŞLIYOR
    // Değişkenleri alalım
    $alici = setting('email');
    $aliciCC = '';
    $konu = "Ticket #" . $SPTid . " Reopened";
    $metin = 'Hello Admin,<br><br>Someone needs you, help now!<br><a href="' . site_url('support') . '" target="_blank">See all open tickets -></a>';
    $Email->Kaydet($alici,$aliciCC,$konu,$metin,date('Y-m-d H:i:s'));
    // E-POSTA GÖNDERİMİ TAMAMLANDI
  else:
    $errormsg = '<div class="alert alert-danger">' . _('An error occured') . '.</div>';
  endif;
elseif (isset($_POST['delete'])):
  $SPTid = post('sptID');
  $guncelle = $Support->Guncelle('spt_onay=:onay, spt_acik=:acik',["onay" => 0, "acik" => 0, "id" => $SPTid]);
  if ($guncelle==1):
    $errormsg = '<div class="alert alert-success">' . _('Ticket closed successfully') . '.</div>';
  else:
    $errormsg = '<div class="alert alert-danger">' . _('An error occured') . '.</div>';
  endif;
endif;

## LOAD HTML
require view('support');
## LOAD HTML
