<?php
$Uye = new App\Classes\Uyelik\Uyeler;

$page = isset($_GET['page']) ? (int) $_GET['page'] : 1;
$perPage = 10;
$offset = ($page - 1) * $perPage;

$order = 'paylasim_tarih DESC LIMIT ' . $offset . ', ' . $perPage;
$paylasimlar = $Veri->from('paylasimlar')->where('paylasim_onay=:onay')->order($order)->selectAll(['onay' => 1]);

if (empty($paylasimlar)) exit;

if ($paylasimlar):
  foreach ($paylasimlar as $post):
    $GonderenKisi = $Uye->Kisi($post['paylasim_user_id'],'user_ad,user_soyad,user_kod,user_resim');
    $GonderenKisiYaz = '<a href="' . site_url('u/' . $GonderenKisi['user_kod']) . '" target="_blank" class="fw-bold text-decoration-none text-dark">' . $GonderenKisi['user_ad'] . ' ' . $GonderenKisi['user_soyad'] . '</a>';
    $likeCount = $Veri->from('paylasim_likes')->where('like_paylasim_id = :pid AND like_type = 1')->count(['pid' => $post['paylasim_id']]);
    $dislikeCount = $Veri->from('paylasim_likes')->where('like_paylasim_id = :pid AND like_type = 0')->count(['pid' => $post['paylasim_id']]);
    echo '
    <div class="card mb-3">
      <div class="card-body d-flex">
        <div class="me-3">
          <img src="' . (!empty($GonderenKisi['user_resim']) ? $GonderenKisi['user_resim'] : public_url('images/nophoto.jpg')) . '" alt="Avatar" class="rounded-circle" width="48" height="48">
        </div>
        <div class="flex-grow-1">
          <div class="d-flex justify-content-between align-items-center mb-1">
            <div>' . $GonderenKisiYaz . '</div>
            ';
              $createdAt = strtotime($post['paylasim_tarih']);
              $now = time();
              $diffInSeconds = $now - $createdAt;
              $threeDaysInSeconds = 3 * 24 * 60 * 60;
              if ($diffInSeconds > $threeDaysInSeconds):
                $formattedDate = '<span class="utc-time" data-utc="' . date('c', $createdAt) . '"></span>';
              else:
                $formattedDate = time_elapsed_string($post['paylasim_tarih']);
              endif;
            echo '
            <small class="text-muted">' . $formattedDate . '</small>
          </div>
          <p class="mb-2">' . nl2br(strip_tags($post['paylasim_metin'])) . '</p>
          <div class="d-flex gap-3">
            <a href="#" class="like-btn text-decoration-none" data-id="' . $post['paylasim_id'] . '" data-type="1">👍 <span class="like-count">' . $likeCount . '</span></a>
            <a href="#" class="like-btn text-decoration-none" data-id="' . $post['paylasim_id'] . '" data-type="0">👎 <span class="dislike-count">' . $dislikeCount . '</span></a>
          </div>
        </div>
      </div>
    </div>';
  endforeach;

  if (count($paylasimlar) < $perPage) {
    echo '<div class="js-feed-end" style="display:none;"></div>';
  }
endif;
?>
<script>
document.querySelectorAll('.like-btn').forEach(btn => {
  btn.addEventListener('click', function (e) {
    e.preventDefault();
    const id = this.dataset.id;
    const type = this.dataset.type;

    fetch("<?= site_url('ajax/like-toggle') ?>", {
      method: "POST",
      headers: { "Content-Type": "application/x-www-form-urlencoded" },
      body: `id=${id}&type=${type}`
    })
    .then(res => res.json())
    .then(data => {
      if (data.success) {
        const card = this.closest('.card');
        card.querySelector('.like-count').textContent = data.likes;
        card.querySelector('.dislike-count').textContent = data.dislikes;
      }
    });
  });
});
</script>
