<?php
if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($BUYEid)) {
  echo json_encode(['success' => false]);
  exit;
}

$postID = (int)post('id');
$type = (int)post('type');

if ($postID <= 0 || ($type !== 0 && $type !== 1)) {
  echo json_encode(['success' => false]);
  exit;
}

// Check if already liked/disliked
$existing = $Veri->from('paylasim_likes')
  ->where('like_user_id = :uid AND like_paylasim_id = :pid')
  ->selectOne(['uid' => $BUYEid, 'pid' => $postID]);

if ($existing) {
  // Toggle or update
  if ((int)$existing['like_type'] === $type) {
    $Veri->delete('paylasim_likes')
      ->where('like_user_id = :uid AND like_paylasim_id = :pid')
      ->deleteOne(['uid' => $BUYEid, 'pid' => $postID]);
  } else {
    $Veri->update('paylasim_likes')
      ->set('like_type = :newtype')
      ->where('like_user_id = :uid AND like_paylasim_id = :pid')
      ->updateOne(['newtype' => $type, 'uid' => $BUYEid, 'pid' => $postID]);
  }
} else {
  $Veri->insert('paylasim_likes')
  ->set('
    like_user_id=:user_id,
    like_paylasim_id=:paylasim_id,
    like_type=:type
  ')
  ->insertOne([
    'user_id' => $BUYEid,
    'paylasim_id' => $postID,
    'type' => $type
  ]);
}

// Recalculate counts
$likes = $Veri->from('paylasim_likes')->where('like_paylasim_id = :pid AND like_type = 1')->count(['pid' => $postID]);
$dislikes = $Veri->from('paylasim_likes')->where('like_paylasim_id = :pid AND like_type = 0')->count(['pid' => $postID]);

echo json_encode([
  'success' => true,
  'likes' => $likes,
  'dislikes' => $dislikes
]);
