<?php
function seo_robots() {
    header('Content-Type: text/plain');

    // Ayarlardan robots.txt içeriği alınıyor
    $robotsContent = setting('robots_txt') ?: "User-agent: *\nDisallow:";

    echo $robotsContent;
    exit;
}

function seo_sitemap() {
    $sitemapFile = PATH . '/sitemap.xml';

    header('Content-Type: application/xml; charset=utf-8');
    if (file_exists($sitemapFile)) {
        readfile($sitemapFile);
    } else {
        echo '<?xml version="1.0" encoding="UTF-8"?>';
        echo '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">';
        echo '<url>';
        echo '<loc>' . htmlspecialchars(site_url()) . '</loc>';
        echo '<changefreq>weekly</changefreq>';
        echo '<priority>1.0</priority>';
        echo '</url>';
        echo '</urlset>';
    }
    exit;
}

if (_url(0) == 'robots.txt'){
    seo_robots();
} elseif (_url(0) == 'sitemap.xml'){
    seo_sitemap();
} else {
    require PATH . '/app/view/404.php';
}
