<?php

namespace App\Classes\Uyelik;

use App\Classes\Database\Veri;

class Uyeler extends Veri
{

  public function Ben($id,$email)
  {

    $ben = parent::from('uyeler')->where('user_id=:id AND user_email=:email')->selectOne(['id' => $id, 'email' => $email]);

    return $ben;

  }

  public function Kisi($id,$select = '*')
  {

    $kisi = parent::from('uyeler')->select($select)->where('user_id=:id')->selectOne(['id' => $id]);

    return $kisi;

  }

  public function Tum($where,$order,$sartlar)
  {

    $Tum = parent::from('uyeler')->where($where)->order($order)->selectAll($sartlar);

    return $Tum;

  }

  public function KisiEmail($select,$email)
  {

    $KisiEmail = parent::from('uyeler')->select($select)->where('user_email=:email')->selectOne(['email' => $email]);

    return $KisiEmail;

  }

  public function KisiKod($select,$kod)
  {

    $KisiKod = parent::from('uyeler')->select($select)->where('user_kod=:kod')->selectOne(['kod' => $kod]);

    return $KisiKod;

  }

  public function Guncelle($data)
  {

    ## Kaydı güncelleyelim
    $islem = parent::update('uyeler')
    ->set('
    user_ad = :ad,
    user_soyad = :soyad,
    user_telefon = :telefon,
    user_dt = :dt,
    user_adres = :adres
    ')
    ->where('user_id = :id')
    ->updateOne($data);
    if ($islem==1):
      $Guncelle = 1;
      return $Guncelle;
      return;
    else:
      $Guncelle = 0;
      return $Guncelle;
      return;
    endif;

  }

  public function GuncelleForm($data)
  {

    ## Kaydı güncelleyelim
    $islem = parent::update('uyeler')
    ->set('
    user_ad = :ad,
    user_soyad = :soyad,
    user_mailPromo = :mailPromo,
    user_mailReport = :mailReport,
    user_smsPromo = :smsPromo,
    user_smsReport = :smsReport
    ')
    ->where('user_id = :id')
    ->updateOne([
      "ad" => $data['ad'],
      "soyad" => $data['soyad'],
      "id" => $data['id'],
      "mailPromo" => $data['mailPromo'],
      "mailReport" => $data['mailReport'],
      "smsPromo" => $data['smsPromo'],
      "smsReport" => $data['smsReport']
    ]);
    if ($islem==1):
      $Guncelle = 1;
      return $Guncelle;
      return;
    else:
      $Guncelle = 0;
      return $Guncelle;
      return;
    endif;

  }

  public function Yeni($data)
  {

    if ($data):

      ## Önce işlem kontrollerini yapalım
      if ( !empty($data['email']) ) :
        $kontrolEmail = parent::from('uyeler')->where('user_email=:email AND user_onay=:onay')->count(["email" => $data['email'], "onay" => 1]);
        if ($kontrolEmail>0) :
          $Yeni = 0;
          return $Yeni;
          return;
        endif;
      endif;

      $Yeni = parent::insert('uyeler')
      ->set('
      user_ad = :ad,
      user_soyad = :soyad,
      user_email = :email,
      user_telefon = :telefon,
      user_tckn = :tckn,
      user_pasaport = :pasaport,
      user_dt = :dt,
      user_cinsiyet = :cinsiyet,
      user_adres = :adres,
      user_medeni = :medeni,
      user_parola = :parola,
      user_kod = :kod,
      user_onay = :onay,
      user_yetki = :yetki,
      user_tarih = :tarih
      ')
      ->insertOne($data);

      if ($Yeni):
        $Yeni = $Yeni;
        return $Yeni;
      else:
        $Yeni = 0;
        return $Yeni;
        return;
      endif;

    else:
      $Yeni = 0;
      return $Yeni;
      return;
    endif;

  }

}
