<?php

namespace App\Classes\Uyelik;

use App\Classes\Database\Veri;

class Log extends Veri
{
    public function add(string $ulog, string $ulogDetay, ?int $userId = null): ?int
    {
        // Eğer userId parametre olarak verilmemişse global değişkenden alalım.
        if ($userId === null) {
            global $BUYEid;
            $userId = $BUYEid;
        }
        
        $data = [
            'userID' => $userId,
            'log'    => $ulog,
            'detay'  => $ulogDetay,
            'ip'     => $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0',
            'tarih'  => date('Y-m-d H:i:s')
        ];
        
        if ($userId!==0) {
            return parent::insert('user_logs')
            ->set('ulog_userID = :userID, ulog_log = :log, ulog_detay = :detay, ulog_ip = :ip, ulog_tarih = :tarih')
            ->insertOne($data);
        }
    }
}