<?php

namespace App\Classes\Uyelik;

use App\Classes\Database\Veri;

class Kayit extends Veri
{
    public function Register(array $data)
    {
        $user_email = $data["email"] ?? '';
        $user_ad    = $data["ad"] ?? '';
        $user_soyad = $data["soyad"] ?? '';
        $user_kod   = $data["kod"] ?? '';
        $user_parola= $data["parola"] ?? '';

        // Zorunlu alan kontrolü
        if (empty($user_email) || empty($user_kod)) {
            return -2;
        }

        // E-posta geçerlilik kontrolü
        if (!filter_var($user_email, FILTER_VALIDATE_EMAIL)) {
            return -2; // İstenirse farklı bir hata kodu kullanılabilir
        }

        // Daha önce aynı e-posta veya kullanıcı kodu kayıtlı mı kontrolü
        $kontrol = parent::from('uyeler')
            ->select('user_email, user_kod')
            ->where('user_email = :email OR user_kod = :kod')
            ->selectAll(['email' => $user_email, 'kod' => $user_kod]);

        if ($kontrol) {
            return 0;
        }

        $result = parent::insert('uyeler')
            ->set('
                user_email = :email,
                user_parola = :parola,
                user_kod = :kod,
                user_onay = :onay,
                user_yetki = :yetki,
                user_tarih = :tarih,
                user_ip = :ip,
                user_ad = :ad,
                user_soyad = :soyad
            ')
            ->insertOne([
                "email"   => $user_email,
                "parola"  => $user_parola,
                "kod"     => $user_kod,
                "onay"    => 1,
                "yetki"   => 0,
                "tarih"   => date('Y-m-d H:i:s'),
                "ip"      => $_SERVER['REMOTE_ADDR'],
                "ad"      => $user_ad,
                "soyad"   => $user_soyad
            ]);

        if ($result) {
            $domain = $_SERVER['HTTP_HOST'];
            setcookie("login", true, time() + (86400 * 30), "/", $domain, true, true);
            setcookie("user_id", encryptData($result), time() + (86400 * 30), "/", $domain, true, true);
            setcookie("user_email", encryptData($user_email), time() + (86400 * 30), "/", $domain, true, true);
            return $result;
        } else {
            return -1;
        }
    }

    public function Subscribe(array $data)
    {
        $check = parent::from('maillist')
            ->select('mlist_id')
            ->where('mlist_email = :email')
            ->selectOne(['email' => $data['email']]);

        if ($check) {
            return $check;
        } else {
            return parent::insert('maillist')
                ->set('
                    mlist_ad = :ad,
                    mlist_soyad = :soyad,
                    mlist_email = :email,
                    mlist_onay = :onay,
                    mlist_ip_no = :ip,
                    mlist_tarih = :tarih
                ')
                ->insertOne([
                    "ad"    => $data['ad'],
                    "soyad" => $data['soyad'],
                    "email" => $data['email'],
                    "onay"  => 1,
                    "tarih" => date('Y-m-d H:i:s'),
                    "ip"    => $_SERVER['REMOTE_ADDR']
                ]);
        }
    }
}