<?php

namespace App\Classes\Uyelik;

use App\Classes\Database\Veri;

class Giris extends Veri
{
    public function Login(array $data): int
    {
        $user_email  = $data['email'] ?? '';
        $user_parola = $data['parola'] ?? '';
        $remember    = $data['remember'] ?? 0;

        // Zorunlu alan kontrolü
        if (empty($user_email) || empty($user_parola)) {
            return 0;
        }

        // Kullanıcı verisini çekiyoruz
        $uyegiris = parent::from('uyeler')
            ->select('user_id, user_email, user_parola')
            ->where('user_email = :email')
            ->selectOne(['email' => $user_email]);

        // Kullanıcı bulunamadıysa veya sonuç boşsa
        if (!$uyegiris) {
            return 0;
        }

        // Şifre doğrulama
        if (!password_verify($user_parola, $uyegiris['user_parola'])) {
            return 0;
        }

        $BUYEid    = $uyegiris['user_id'];
        $BUYEemail = $uyegiris['user_email'];

        // "Remember me" seçeneğine göre cookie sürelerini ayarlıyoruz
        $expiry = ($remember == 1) ? time() + (86400 * 30) : time() + (86400 * 2);
        setcookie("login", true, $expiry, "/", null, true);
        setcookie("user_id", encryptData($BUYEid), $expiry, "/", null, true);
        setcookie("user_email", encryptData($BUYEemail), $expiry, "/", null, true);

        return $BUYEid;
    }
}