<?php

namespace App\Classes\Destek;

use App\Classes\Database\Veri;

class Genel extends Veri
{

  public function YeniEtiket($data)
  {

    $islem = parent::insert('destek')
    ->set('
    spt_userID=:userID,
    spt_baslik=:baslik,
    spt_metin=:metin,
    spt_onem=:onem,
    spt_tarih=:tarih,
    spt_public=:public
    ')
    ->insertOne($data);
    if ($islem>0):
      $sonuc = 1;
    else:
      $sonuc = 0;
    endif;
    return $sonuc;

  }

  public function EtiketKisi($id)
  {

    $islem = parent::from('destek')->select('spt_userID')->where('spt_id=:id')->selectOne(["id" => $id]);
    if ($islem):
      $sonuc = $islem['spt_userID'];
    else:
      $sonuc = 0;
    endif;
    return $sonuc;

  }

  public function YeniCevap($data)
  {

    $islem = parent::insert('destekCevap')
    ->set('
    ans_userID=:userID,
    ans_supportID=:supportID,
    ans_metin=:metin,
    ans_tarih=:tarih
    ')
    ->insertOne($data);
    if ($islem>0):
      $kisiBAK = self::EtiketKisi($data['supportID']);
      if ( $kisiBAK>0 ):
        $sonuc = $kisiBAK;
      else:
        $sonuc = 1;
      endif;
    else:
      $sonuc = 0;
    endif;
    return $sonuc;

  }

  public function Begen($id,$begen)
  {

    $ansAl = parent::from('destekCevap')->select('ans_iyi')->where('ans_id=:id')->selectOne(["id" => $id]);
    if ( $ansAl ):
      $GuncelLike = $ansAl['ans_iyi'];
    endif;

    if ($begen==1):
      // like
      $Like = 1;
    else:
      // dislike
      $Like = -1;
    endif;

    $YeniLike = $GuncelLike + $Like;
    $LikeSon = parent::update('destekCevap')->set('ans_iyi=:iyi')->where('ans_id=:id')->updateOne(["iyi" => $YeniLike, "id" => $id]);
    if ($LikeSon>0):
      $sonuc=1;
    else:
      $sonuc=0;
    endif;

    return $sonuc;

  }

  public function Guncelle($set,$data)
  {

    $islem = parent::update('destek')->set($set)->where('spt_id=:id')->updateOne($data);
    if ($islem>0):
      $sonuc = 1;
    else:
      $sonuc = 0;
    endif;

    return $sonuc;

  }

}
