<?php
namespace App\Classes\Database;

use \PDO;
use \PDOException;

class Veri
{
    private $pdo;
    private $sql;

    public function __construct($dbName = 'VERI')
    {
        $this->pdo = Database::getConnection($dbName);

        if (!$this->pdo) {
            throw new \Exception("Database connection failed for: " . $dbName);
        }
    }

    public function insert($tabloAdi)
    {
        $this->sql = 'INSERT INTO ' . $tabloAdi;
        return $this;
    }

    public function update($tabloAdi)
    {
        $this->sql = 'UPDATE ' . $tabloAdi;
        return $this;
    }

    public function delete($tabloAdi)
    {
        $this->sql = 'DELETE FROM ' . $tabloAdi;
        return $this;
    }

    public function from($tabloAdi)
    {
        $this->sql = 'SELECT * FROM ' . $tabloAdi;
        return $this;
    }

    public function join($table, $on, $type = 'INNER')
    {
        $this->sql .= " $type JOIN $table ON $on";
        return $this;
    }

    public function select($kolonlar)
    {
        $this->sql = str_replace('*', $kolonlar, $this->sql);
        return $this;
    }

    public function set($sutunlar)
    {
        $this->sql .= ' SET ' . $sutunlar;
        return $this;
    }

    public function whereDate($tarih, $sutunlar)
    {
        $this->sql .= ' WHERE (' . $tarih . ' BETWEEN :start_date AND :end_date) AND ' . $sutunlar;
        return $this;
    }

    public function where($sutunlar)
    {
        $this->sql .= ' WHERE ' . $sutunlar;
        return $this;
    }

    public function order($ref)
    {
        $this->sql .= ' ORDER BY ' . $ref;
        return $this;
    }

    public function runCustomQuery($sql, $params = [])
    {
        $query = $this->pdo->prepare($sql);
        $query->execute($params);
        return $query->fetchAll(PDO::FETCH_ASSOC);
    }

    public function execute($params = [])
    {
        $query = $this->pdo->prepare($this->sql);
        $query->execute($params);
        $this->sql = ''; // Sorguyu sıfırla
        return $query;
    }

    public function selectDate($ilk, $son)
    {
        $query = $this->pdo->prepare($this->sql);
        $query->bindParam(':start_date', $ilk, PDO::PARAM_STR);
        $query->bindParam(':end_date', $son, PDO::PARAM_STR);
        $query->execute();
        return $query->fetchAll(PDO::FETCH_ASSOC) ?: [];
    }

    public function selectAll($sartlar)
    {
        $query = $this->pdo->prepare($this->sql);
        $query->execute($sartlar);
        return $query->fetchAll(PDO::FETCH_ASSOC) ?: [];
    }

    public function selectOne($sartlar)
    {
        $query = $this->pdo->prepare($this->sql);
        $query->execute($sartlar);
        return $query->fetch(PDO::FETCH_ASSOC) ?: null;
    }

    public function insertOne($sartlar)
    {
        $query = $this->pdo->prepare($this->sql);
        if ($query->execute($sartlar)) {
            return $this->pdo->lastInsertId();
        }
        return 0;
    }

    public function updateOne($sartlar)
    {
        $query = $this->pdo->prepare($this->sql);
        return $query->execute($sartlar) ? 1 : 0;
    }

    public function updateAll($sartlar)
    {
        $query = $this->pdo->prepare($this->sql);
        $query->execute($sartlar);
        return $query->rowCount(); // Güncellenen satır sayısını döndür
    }

    public function sumColumn($sartlar)
    {
        $query = $this->pdo->prepare($this->sql);
        $query->execute($sartlar);
        return $query->fetchColumn() ?: 0;
    }

    public function count($sartlar)
    {
        $query = $this->pdo->prepare($this->sql);
        $query->execute($sartlar);
        return $query->rowCount();
    }

    public function deleteOne($sartlar)
    {
        $query = $this->pdo->prepare($this->sql);
        return $query->execute($sartlar) ? 1 : 0;
    }

    public function deleteAll($sartlar)
    {
        $query = $this->pdo->prepare($this->sql);
        return $query->execute($sartlar) ? 1 : 0;
    }

    public function __destruct()
    {
        // Bağlantı temizleme işlemi (gerekirse)
    }
}
