<?php
namespace App\Classes\Database;

use \PDO;
use \PDOException;

class Database
{
    private static $instances = []; // Tüm bağlantıları burada saklıyoruz.

    private function __construct() {} // Dışarıdan nesne oluşturulmasını engelle

    public static function getConnection($dbName)
    {
        if (!isset(self::$instances[$dbName])) {

            // Verileri kontrol etmek için loglama
            $host = getenv(strtoupper($dbName) . '_DB_HOST') ?: ($_ENV[strtoupper($dbName) . '_DB_HOST'] ?? null);
            $dbname = getenv(strtoupper($dbName) . '_DB_NAME') ?: ($_ENV[strtoupper($dbName) . '_DB_NAME'] ?? null);
            $username = getenv(strtoupper($dbName) . '_DB_USER') ?: ($_ENV[strtoupper($dbName) . '_DB_USER'] ?? null);
            $password = getenv(strtoupper($dbName) . '_DB_PASS') ?: ($_ENV[strtoupper($dbName) . '_DB_PASS'] ?? null);
            $charset = 'utf8';

            // Eğer herhangi bir değer eksikse hata verelim
            if (!$host || !$dbname || !$username || !$password) {
                throw new \Exception("Database credentials for '$dbName' are missing or incorrect.");
            }

            $dsn = "mysql:host=$host;dbname=$dbname;charset=$charset";

            try {
                self::$instances[$dbName] = new PDO($dsn, $username, $password, [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
                ]);

            } catch (PDOException $exception) {
                throw new \Exception("Database connection failed for '$dbName': " . $exception->getMessage());
            }
        }

        return self::$instances[$dbName];
    }
}
