<?php

namespace App\Classes\Blog;

use App\Classes\Blog\Genel;
use App\Classes\Database\Veri;

class Yorumlar extends Genel
{

  public function TumYorumlar($select,$where,$order,$sartlar)
  {

    $TumYorumlar = parent::from('yorumlar')->select($select)->where($where)->order($order)->selectAll($sartlar);

    return $TumYorumlar;

  }

  public function Yorumlar($id)
  {

    $select = 'comment_id,comment_userID,comment_tarih,comment_yorum';
    $where = 'comment_blogID=:blogID AND comment_onay=:onay';
    $order = 'comment_tarih DESC';
    $sartlar = ["blogID" => $id, "onay" => 1];

    $TumYorumlar = self::TumYorumlar($select,$where,$order,$sartlar);

    return $TumYorumlar;

  }

  public function Yorum($id)
  {

    $Yorum = parent::from('yorumlar')->where('comment_id=:id')->selectOne(['id' => $id]);

    return $Yorum;

  }

  public function YorumKisi($id)
  {

    $YorumKisi = parent::from('uyeler')->select('user_kod')->where('user_id=:id')->selectOne(['id' => $id]);

    return $YorumKisi;

  }

  public function YorumSay($id)
  {

    $result = parent::from('yorumlar')
    ->where('comment_blogID=:blogID AND comment_onay=:onay')
    ->count(["blogID" => $id, "onay" => 1]);

    return $result;

  }

  public function Ekle($id,$metin)
  {

    global $BUYEid,$_SERVER;

    $result = Veri::insert('yorumlar')
    ->set('
    comment_userID=:userID,
    comment_blogID=:blogID,
    comment_tarih=:tarih,
    comment_onay=:onay,
    comment_ip=:ip,
    comment_yorum=:yorum
    ')
    ->insertOne([
      "userID" => $BUYEid,
      "blogID" => $id,
      "tarih" => date('Y-m-d H:i:s'),
      "onay" => 1,
      "ip" => $_SERVER['SERVER_ADDR'],
      "yorum" => $metin
    ]);

    return $result;

  }

}
