<?php

namespace App\Classes\Blog;

use App\Classes\Database\Veri;

class Genel extends Veri
{

  public function TumYazilar($kat, $q, $lang, $order)
  {
      $whereParts = [
          'content_onay = :onay',
          'content_blog = :blog',
          'content_lang = :lang'
      ];

      $params = [
          'onay' => 1,
          'blog' => 0,
          'lang' => $lang
      ];

      // Kategori kodunu ID'ye çevir
      if (strlen($kat) > 1) {
          $cat = self::KatKod('cat_id', $kat);
          if ($cat) {
              $params['katID'] = $cat['cat_id'];
              $whereParts[] = 'content_katID = :katID';
          }
      }

      // Arama terimi varsa
      if (!empty($q)) {
          $params['kelime'] = '%' . $q . '%';
          $whereParts[] = '(
              content_baslik LIKE :kelime OR 
              content_link LIKE :kelime OR 
              content_etiket LIKE :kelime
          )';
      }

      // Where cümlesini birleştir
      $where = implode(' AND ', $whereParts);

      // Sorguyu oluştur ve veriyi çek
      $data = parent::from('icerik')
          ->where($where)
          ->order($order)
          ->selectAll($params);

      return $data;
  }

  public function BlogSay($kat,$lang = 'en')
  {

    if (strlen($kat)>1):
      $cat = self::KatKod('cat_id',$kat);
      if ($cat):
        $kat=$cat['cat_id'];
      endif;
      $where = 'content_onay=:onay AND content_blog=:blog AND content_katID=:katID AND content_lang=:lang';
      $count = ["onay" => 1, "blog" => 0, "katID" => $kat, "lang" => $lang];
    else:
      $where = 'content_onay=:onay AND content_blog=:blog AND content_lang=:lang';
      $count = ["onay" => 1, "blog" => 0, "lang" => $lang];
    endif;

    $result = parent::from('icerik')->where($where)->count($count);

    return $result;

  }

  public function Hit($id,$eskihit)
  {

    $yenihit = $eskihit + 1;

    $Hit = parent::update('icerik')->set('content_hit=:hit')->where('content_id=:id')->updateOne(["hit" => $yenihit, "id" => $id]);

  }

  public function Next($id,$lang,$blog)
  {

    $Next = Veri::from('icerik')->select('content_kod,content_baslik')->where('content_id<:id AND content_onay=:onay AND content_blog=:blog AND content_lang=:lang')->order('content_id DESC LIMIT 1')->selectAll(['id' => $id, 'onay' => 1, 'lang' => $lang, 'blog' => $blog]);
    if ($Next):
      foreach ($Next as $row):
        $Done = ['kod' => $row['content_kod'], 'baslik' => $row['content_baslik']];
      endforeach;
    else:
      $Done = ['kod' => '#', 'baslik' => 'N/A'];
    endif;

    return '<a href="' . $Done['kod'] . '" class="d-inline-flex align-items-center text-dark h-text-color"><span>' . $Done['baslik'] . '</span><i class="uil uil-angle-right-b fs-3 ms-1"></i></a>';

  }

  public function Prev($id,$lang,$blog)
  {

    $Prev = Veri::from('icerik')->select('content_kod,content_baslik')->where('content_id>:id AND content_onay=:onay AND content_blog=:blog AND content_lang=:lang')->order('content_id ASC LIMIT 1')->selectAll(['id' => $id, 'onay' => 1, 'lang' => $lang, 'blog' => $blog]);
    if ($Prev):
      foreach ($Prev as $row):
        $Done = ['kod' => $row['content_kod'], 'baslik' => $row['content_baslik']];
      endforeach;
    else:
      $Done = ['kod' => '#', 'baslik' => 'N/A'];
    endif;

    return '<a href="' . $Done['kod'] . '" class="d-inline-flex align-items-center text-dark h-text-color"><i class="uil uil-angle-left-b fs-3 me-1"></i><span>' . $Done['baslik'] . '</span></a>';

  }

  public function KatHit($id,$eskihit)
  {

    $yenihit = $eskihit + 1;

    $KatHit = parent::update('icerik_kat')->set('cat_hit=:hit')->where('cat_id=:id')->updateOne(["hit" => $yenihit, "id" => $id]);

  }

  public function Slide($order)
  {

    $data = parent::from('icerik')->select('content_resim_thumb,content_resim,content_link,content_tarih,content_kod')->where('content_onay=:onay AND content_blog=:blog AND content_slide=:slide')->order($order)->selectAll(["onay" => 1, "blog" => 0, "slide" => 1]);

    return $data;

  }

  public function Yazilar($order,$lang)
  {

    $data = parent::from('icerik')->where('content_onay=:onay AND content_lang=:lang AND content_blog=:blog')->order($order)->selectAll(["onay" => 1, "blog" => 0, "lang" => $lang]);

    return $data;

  }

  public function TumKategoriler($onay)
  {

    if ($onay==1):
      $data = parent::from('icerik_kat')->where('cat_onay=:onay')->selectAll(["onay" => 1]);
    else:
      $data = parent::from('icerik_kat')->selectAll();
    endif;

    return $data;

  }

  public function KatSay()
  {

    $result = parent::from('icerik_kat')
    ->where('cat_onay=:onay')
    ->count(["onay" => 1]);

    return $result;

  }

  public function NavKategoriler($limit)
  {

    $data = parent::from('icerik_kat')->where('cat_onay=:onay')->order('cat_hit DESC LIMIT ' . $limit)->selectAll(["onay" => 1]);

    return $data;

  }

  public function NavMenu($id)
  {

    if ($id!=0):

      $data = parent::from('navmenu')->where('nav_katID=:katID AND nav_kat=:kat')->order('nav_sira ASC')->selectAll(["katID" => $id, "kat" => 1]);

    else:

      $data = parent::from('navmenu')->where('nav_kat=:kat')->order('nav_sira ASC')->selectAll(["kat" => 0]);

    endif;

    return $data;

  }

  public function Yazi($select,$id)
  {

    $data = parent::from('icerik')->select($select)->where('content_id=:id')->selectOne(["id" => $id]);

    return $data;

  }

  public function KatKod($select,$kod)
  {

    $data = parent::from('icerik_kat')->select($select)->where('cat_kod=:kod')->selectOne(["kod" => $kod]);

    return $data;

  }

  public function Kategori($select,$id)
  {

    $data = parent::from('icerik_kat')->select($select)->where('cat_id=:id')->selectOne(["id" => $id]);

    return $data;

  }

  public function Oku($url)
  {

    $data = parent::from('icerik')->where('content_kod=:kod')->selectOne(["kod" => $url]);

    return $data;

  }

  public function SEO($url,$select)
  {

    $data = parent::from('icerik')->select($select)->where('content_kod=:kod')->selectOne(["kod" => $url]);

    return $data;

  }

  public function EtiketVirgulsuz($tags)
  {

    $tags = explode(",",$tags);

    $results = '';

    if ($tags):
      $i=0;
      foreach ($tags as $row):
        $results .= '<a href="' . site_url('r?q=' . $tags[$i]) . '" target="_blank">' . $tags[$i] . '</a> ';
        $i=$i+1;
      endforeach;
      $results = rtrim($results," ");
    endif;

    return $results;

  }

  public function Etiket($tags)
  {

    $tags = explode(",",$tags);

    $results = '';

    if ($tags):
      $i=0;
      foreach ($tags as $row):
        $results .= '<a href="' . site_url('blog?q=' . $tags[$i]) . '" target="_blank">' . $tags[$i] . '</a>, ';
        $i=$i+1;
      endforeach;
      $results = rtrim($results,", ");
    endif;

    return $results;

  }

  public function EtiketLinksiz($tags)
  {

    $tags = explode(",",$tags);

    $results = '';

    if ($tags):
      $i=0;
      foreach ($tags as $row):
        $results .= $tags[$i] . ', ';
        $i=$i+1;
      endforeach;
      $results = rtrim($results,", ");
    endif;

    return $results;

  }

}