<?php

namespace App\Classes\Admin;

use App\Classes\Database\Veri;

class Yorumlar extends Veri
{

  public function SonYorum($select)
  {

    $SonYorum = parent::from('yorumlar')->select($select)->where('comment_onay=:onay')->order('comment_tarih DESC')->selectOne(["onay" => 1]);

    return $SonYorum;

  }

  public function TumYorumlar($where,$order,$sartlar)
  {

    $TumYorumlar = parent::from('yorumlar')->where($where)->order($order)->selectAll($sartlar);

    return $TumYorumlar;

  }

  public function Yorum($id)
  {

    $Yorum = parent::from('yorumlar')->where('comment_id=:id')->selectOne(['id' => $id]);

    return $Yorum;

  }

  public function Yazi($select,$id)
  {

    $Yazi = parent::from('icerik')->select($select)->where('content_id=:id')->selectOne(['id' => $id]);

    return $Yazi;

  }

  public function Sil($id)
  {

    $Sil = parent::delete('yorumlar')->where('comment_id=:id')->deleteOne(["id" => $id]);

    return $Sil;

  }

}
