<?php

namespace App\Classes\Admin;

use App\Classes\Database\Veri;

class Say extends Veri
{

  public function Uyeler()
  {

    $result = parent::from('uyeler')
    ->where('user_onay=:onay')
    ->count(["onay" => 1]);

    return $result;

  }

  public function Blog()
  {

    $result = parent::from('icerik')
    ->where('content_onay=:onay AND content_blog=:blog')
    ->count(["onay" => 1, "blog" => 0]);

    return $result;

  }

  public function Kategoriler()
  {

    $result = parent::from('icerik_kat')
    ->where('cat_onay=:onay')
    ->count(["onay" => 1]);

    return $result;

  }

  public function Yorumlar()
  {

    $result = parent::from('yorumlar')
    ->where('comment_onay=:onay')
    ->count(["onay" => 1]);

    return $result;

  }

  public function Etiketler()
  {

    $result = parent::from('destek')
    ->where('spt_onay=:onay')
    ->count(["onay" => 1]);

    return $result;

  }

  public function Formlar()
  {

    $result = parent::from('destek')
    ->where('spt_onay=:onay AND spt_userID=:userID')
    ->count(["onay" => 1, "userID" => 0]);

    return $result;

  }

}
