<?php

namespace App\Classes\Admin;

use App\Classes\Database\Veri;

class Kategoriler extends Veri
{

  public function SonKategori($select)
  {

    $SonYorum = parent::from('icerik_kat')->select($select)->where('cat_onay=:onay')->order('cat_id DESC')->selectOne(["onay" => 1]);

    return $SonYorum;

  }

  public function TumKategoriler($where,$order,$sartlar)
  {

    $TumYorumlar = parent::from('icerik_kat')->where($where)->order($order)->selectAll($sartlar);

    return $TumYorumlar;

  }

  public function Kategori($id)
  {

    $Yorum = parent::from('icerik_kat')->where('cat_id=:id')->selectOne(['id' => $id]);

    return $Yorum;

  }

  public function Ekle($data)
  {

    $Yazi = parent::from('icerik_kat')->select($select)->where('cat_id=:id')->selectOne(['id' => $id]);

    return $Yazi;

  }

  public function Sil($id)
  {

    $Sil = parent::delete('icerik_kat')->where('cat_id=:id')->deleteOne(["id" => $id]);

    return $Sil;

  }

}
