<?php

namespace App\Classes\Admin;

use App\Classes\Database\Veri;

class Destek extends Veri
{

  public function SonDestek($select)
  {

    $SonDestek = parent::from('destek')->select($select)->where('spt_onay=:onay')->order('spt_tarih DESC')->selectOne(["onay" => 1]);

    return $SonDestek;

  }

  public function TumDestek($where,$order,$sartlar)
  {

    $TumDestek = parent::from('destek')->where($where)->order($order)->selectAll($sartlar);

    return $TumDestek;

  }

  public function Destek($id)
  {

    $Destek = parent::from('destek')->where('spt_id=:id')->selectOne(['id' => $id]);

    return $Destek;

  }

  public function DestekYanitlar($where,$order,$sartlar)
  {

    $DestekYanitlar = parent::from('destekCevap')->where($where)->order($order)->selectAll($sartlar);

    return $DestekYanitlar;

  }

  public function DestekSayisi($where,$sartlar)
  {

    $result = parent::from('destek')
    ->where($where)
    ->count($sartlar);

    return $result;

  }

  public function DestekBul($where,$select,$order,$sartlar)
  {

    $DestekBul = parent::from('destek')->where($where)->select($select)->order($order)->selectOne($sartlar);

    return $DestekBul;

  }

}
