<?php

namespace App\Classes\Admin;

use App\Classes\Database\Veri;

class Blog extends Veri
{

  public function SonYazi($select)
  {

    $SonYazi = parent::from('icerik')->select($select)->where('content_onay=:onay AND content_blog=:blog')->order('content_tarih DESC')->selectOne(["onay" => 1, "blog" => 1]);

    return $SonYazi;

  }

  public function TumYazilar($where,$order,$sartlar)
  {

    $TumYazilar = parent::from('icerik')->where($where)->order($order)->selectAll($sartlar);

    return $TumYazilar;

  }

  public function Yazi($id)
  {

    $Yazi = parent::from('icerik')->where('content_id=:id')->selectOne(['id' => $id]);

    return $Yazi;

  }

  public function TumKategoriler($select)
  {

    $data = parent::from('icerik_kat')->select($select)->where('cat_onay=:onay')->selectAll(["onay" => 1]);

    return $data;

  }

}
