<?php require admin_view('static/header') ?>

<?php if ((isset($errmsg)) && ($errmsg!=='error')): ?>
<div class="box-container">
    <div class="box" id="div-0">
        <div class="box-content">
            <h3 class="mb-3"><i class="icon-check"></i> Güncelleme Başarılı!</h3>
            <p class="mb-2">Sisteminiz başarıyla <strong>v<?= $errmsg ?? 'Unknown' ?></strong> sürümüne güncellendi.</p>
            <a href="<?= admin_url() ?>" class="btn btn-primary mt-3"><i class="icon-line2-home"></i> Anasayfaya Dön</a>
            <?php
            $logPath = __DIR__ . '/../../logs/update-log.txt';
            if (file_exists($logPath)):
                $logContent = file_get_contents($logPath);
            ?>
            <br><br>
            <details class="mt-4">
            <summary>📜 Güncelleme Geçmişini Göster</summary>
            <pre class="text-start bg-light p-3 mt-2" style="max-height: 300px; overflow: auto; font-size: 0.9rem;">
            <?= htmlspecialchars($logContent) ?>
            </pre>
            </details>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php elseif ((isset($errmsg)) && ($errmsg==='error')): ?>
<div class="box-container">
    <div class="box" id="div-0">
        <div class="box-content">
            <h3 class="mb-3"><i class="icon-remove"></i> Güncelleme Hatası!</h3>
            <p class="mb-2"><?= $_SESSION['update_error'] ?? 'Bir hata oluştu, lütfen tekrar deneyin.' ?></p>
            <a href="<?= admin_url('update') ?>" class="btn btn-secondary mt-3"><i class="icon-line2-refresh"></i> Yeniden Dene</a>
        </div>
    </div>
</div>
<?php else: ?>
<div class="box-container">
    <div class="box" id="div-0">
        <div class="box-content">
            <h3 class="mb-3"><i class="icon-info"></i> Güncelleme Durumu</h3>
            <p class="mb-2">Gösterilecek bir güncelleme sonucu bulunamadı.</p>
        </div>
    </div>
</div>
<?php endif; ?> 

<?php require admin_view('static/footer') ?>