<?php $_SESSION['tokenMuaf'] = true; ?>

<div class="box-">
  <h1>Social Media Settings</h1>
</div>

<div class="clear" style="height: 10px;"></div>

<div id="setting-response" style="margin-bottom: 15px;"></div>
<?php
$socialJson = setting('social_accounts');
$socialAccounts = [];
if (is_string($socialJson) && !empty($socialJson)) {
    $decodedJson = html_entity_decode($socialJson);
    $decoded = json_decode($decodedJson, true);
    if (json_last_error() === JSON_ERROR_NONE && is_array($decoded)) {
        $socialAccounts = $decoded;
    }
}
?>

<div class="setting-card">
  <div id="social-accounts-list">
    <?php foreach ($socialAccounts as $i => $acc): ?>
      <div class="setting-item" data-index="<?= $i ?>">
        <div class="setting-info" style="width:100%;">
          <select class="setting-select" name="social_platform[]" style="margin-bottom:6px;">
            <?php foreach ($availablePlatforms as $key => $p): ?>
              <option value="<?= $key ?>" <?= ($acc['platform'] === $key) ? 'selected' : '' ?>><?= $p['name'] ?></option>
            <?php endforeach; ?>
          </select>
          <input type="text" class="setting-input" name="social_username[]" value="<?= htmlspecialchars($acc['username']) ?>" placeholder="Username">
          <input type="text" class="setting-input" name="social_title[]" value="<?= htmlspecialchars($acc['title'] ?? '') ?>" placeholder="Optional Display Name">
        </div>
        <button type="button" class="btn btn-sm btn-danger remove-social" style="margin-top: 8px;">Remove</button>
      </div>
    <?php endforeach; ?>
  </div>
  <button type="button" class="btn btn-sm btn-primary" id="add-social-account">+ Add Social Account</button>
  <div style="margin-top: 15px;">
    <button id="save-social-settings" class="btn btn-success btn-lg">Save All Changes on Social Accounts</button>
  </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
  const container = document.getElementById('social-accounts-list');
  const addBtn = document.getElementById('add-social-account');
  const platforms = <?= json_encode($availablePlatforms) ?>;

  addBtn.addEventListener('click', () => {
    const index = container.children.length;
    const selectedPlatforms = Array.from(container.querySelectorAll('select[name="social_platform[]"]')).map(s => s.value);
    const remainingPlatforms = Object.keys(platforms).filter(p => !selectedPlatforms.includes(p));
    if (remainingPlatforms.length === 0) {
      alert('All available platforms have already been added.');
      return;
    }
    
    const wrapper = document.createElement('div');
    wrapper.classList.add('setting-item');
    wrapper.dataset.index = index;

    let options = '';
    for (const [key, val] of Object.entries(platforms)) {
      if (!selectedPlatforms.includes(key)) {
        options += `<option value="${key}">${val.name}</option>`;
      }
    }

    wrapper.innerHTML = `
      <div class="setting-info" style="width:100%;">
        <select class="setting-select" name="social_platform[]" style="margin-bottom:6px;">${options}</select>
        <input type="text" class="setting-input" name="social_username[]" placeholder="Username">
        <input type="text" class="setting-input" name="social_title[]" placeholder="Optional Display Name">
      </div>
      <button type="button" class="btn btn-sm btn-danger remove-social" style="margin-top: 8px;">Remove</button>
    `;
    container.appendChild(wrapper);
  });

  container.addEventListener('click', function (e) {
    if (e.target && e.target.classList.contains('remove-social')) {
      e.target.closest('.setting-item').remove();
    }
  });

  document.getElementById('save-social-settings').addEventListener('click', () => {
    const items = document.querySelectorAll('#social-accounts-list .setting-item');
    const accounts = [];

    items.forEach(item => {
      const platform = item.querySelector('select[name="social_platform[]"]').value;
      const username = item.querySelector('input[name="social_username[]"]').value.trim();
      const title = item.querySelector('input[name="social_title[]"]').value.trim();

      if (platform && username) {
        accounts.push({ platform, username, title });
      }
    });

    const data = new URLSearchParams();
    data.append('setting', 'social_accounts');
    data.append('value', JSON.stringify(accounts));

    fetch('<?= admin_url("ajax/save-setting") ?>', {
      method: 'POST',
      headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
      body: data.toString()
    })
    .then(res => res.json())
    .then(res => {
      const box = document.getElementById('setting-response');
      if (res.success) {
        box.innerHTML = '<div class="alert alert-success">Saved successfully.</div>';
      } else {
        box.innerHTML = '<div class="alert alert-danger">Save failed: ' + (res.message || 'Unknown error') + '</div>';
      }
    })
    .catch(() => {
      document.getElementById('setting-response').innerHTML = '<div class="alert alert-danger">Network error.</div>';
    });
  });
});
</script>