<?php $_SESSION['tokenMuaf'] = true; ?>

<div class="box-">
  <h1>Sitemap.xml Settings</h1>
</div>

<div class="clear" style="height: 10px;"></div>

<div id="setting-response" style="margin-bottom: 15px;"></div>

<div class="setting-card">
  <div class="setting-item">
    <strong>Last Generated:</strong>
    <span id="sitemap-last-generated">
      <?= setting('sitemap_last_generated') ? date("Y-m-d H:i:s", strtotime(setting('sitemap_last_generated'))) : 'Not generated yet' ?>
    </span>
  </div>
  <div class="setting-item">
    <strong>Sitemap URL:</strong>
    <span><a href="<?= site_url('sitemap.xml') ?>" target="_blank"><?= site_url('sitemap.xml') ?></a></span>
  </div>
  <div class="setting-item">
    <button class="btn btn-primary" id="generate-sitemap">Generate Sitemap</button>
  </div>
  <div class="setting-item">
    <strong>Manually Added URLs</strong>
    <p>You can manually add important URLs below (e.g., /custom-page).</p>
    <?php
    $defaultManualUrls = implode("\n", array_map(fn($url) => $url, $staticPages));
    if ((!setting('sitemap_manual_urls')) || (setting('sitemap_manual_urls') !== $defaultManualUrls)) {
        save_settings(['sitemap_manual_urls' => $defaultManualUrls]);
    }
    
    $defaultCheckboxSettings = [
      'sitemap_include_blog',
      'sitemap_include_categories',
      'sitemap_include_support'
    ];
    foreach ($defaultCheckboxSettings as $settingKey) {
        if (setting($settingKey) === null) {
            save_settings([$settingKey => 1]);
        }
    }
    ?>
    <textarea name="settings[sitemap_manual_urls]" class="setting-input" data-setting-name="sitemap_manual_urls" rows="5" class="form-control"><?= implode("\n", array_map(fn($url) => $url, $staticPages)) ?></textarea>
  </div>
  <div class="setting-item">
    <strong>Content to Include in Sitemap</strong>
    <p>Select which content types should be added to the sitemap:</p>
    <div>
      <label><input type="checkbox" class="setting-input" data-setting-name="sitemap_include_blog" name="settings[sitemap_include_blog]" checked /> Blog Posts</label><br>
      <label><input type="checkbox" class="setting-input" data-setting-name="sitemap_include_categories" name="settings[sitemap_include_categories]" checked /> Blog Categories</label><br>
      <label><input type="checkbox" class="setting-input" data-setting-name="sitemap_include_support" name="settings[sitemap_include_support]" checked /> Support Pages</label>
    </div>
  </div>
</div>

<script>
  document.getElementById('generate-sitemap').addEventListener('click', function () {
    const btn = this;
    btn.disabled = true;
    btn.innerText = 'Generating...';

    fetch('<?= admin_url("ajax/generate-sitemap") ?>', {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json'
      },
      body: JSON.stringify({})
    })
    .then(res => res.json())
    .then(data => {
      if (data.status === 'success') {
        document.getElementById('sitemap-last-generated').innerText = data.generated_at;
        document.getElementById('setting-response').innerHTML = '<div class="alert alert-success">Sitemap successfully generated!</div>';
        btn.disabled = false;
        btn.innerText = 'Generate Sitemap';
      } else {
        document.getElementById('setting-response').innerHTML = '<div class="alert alert-danger">' + (data.message || 'An error occurred.') + '</div>';
        btn.disabled = false;
        btn.innerText = 'Generate Sitemap';
      }
    })
    .catch(() => {
      document.getElementById('setting-response').innerHTML = '<div class="alert alert-danger">Request failed. Please try again.</div>';
      btn.disabled = false;
      btn.innerText = 'Generate Sitemap';
    });
  });

  function saveSetting(name, value) {
    fetch('<?= admin_url("settings/update") ?>', {
      method: 'POST',
      headers: {
        'Content-Type': 'application/x-www-form-urlencoded'
      },
      body: new URLSearchParams({ name: name, value: value })
    });
  }

  // Attach change listeners
  document.getElementById('sitemap_manual_urls').addEventListener('input', function () {
    saveSetting('sitemap_manual_urls', this.value);
  });

  ['sitemap_include_blog', 'sitemap_include_categories', 'sitemap_include_support'].forEach(id => {
    const el = document.getElementById(id);
    el.addEventListener('change', function () {
      saveSetting(this.id, this.checked ? 1 : 0);
    });
  });
</script>