<?php $_SESSION['tokenMuaf'] = true; ?>

<div class="box-">
  <h1>SEO Settings</h1>
</div>

<div class="clear" style="height: 10px;"></div>

<div id="setting-response" style="margin-bottom: 15px;"></div>

<?php foreach ($supportedLanguages as $lang): ?>
  <div class="setting-card">
    <div class="setting-item">
      <div class="setting-info">
        <strong>Meta Title (<?= strtoupper($lang) ?>)</strong>
        <p>This is the main title that appears in browser tabs and search engine results.</p>
        <input type="text" class="setting-input"
               name="settings[title_<?= $lang ?>]"
               data-setting-name="title_<?= $lang ?>"
               value="<?= htmlspecialchars((string) setting('title_' . $lang)) ?>">
      </div>
    </div>

    <div class="setting-item">
      <div class="setting-info">
        <strong>Meta Description (<?= strtoupper($lang) ?>)</strong>
        <p>Short description that appears under your site title in search results.</p>
        <input type="text" class="setting-input"
               name="settings[description_<?= $lang ?>]"
               data-setting-name="description_<?= $lang ?>"
               value="<?= htmlspecialchars((string) setting('description_' . $lang)) ?>">
      </div>
    </div>

    <div class="setting-item">
      <div class="setting-info">
        <strong>Meta Keywords (<?= strtoupper($lang) ?>)</strong>
        <p>Comma-separated list of keywords describing your website.</p>
        <input type="text" class="setting-input"
               name="settings[keywords_<?= $lang ?>]"
               data-setting-name="keywords_<?= $lang ?>"
               value="<?= htmlspecialchars((string) setting('keywords_' . $lang)) ?>">
      </div>
    </div>

    <div class="setting-item">
      <div class="setting-info">
        <strong>Open Graph Title (<?= strtoupper($lang) ?>)</strong>
        <p>Used for social media previews, especially on Facebook and LinkedIn.</p>
        <input type="text" class="setting-input"
               name="settings[og_title_<?= $lang ?>]"
               data-setting-name="og_title_<?= $lang ?>"
               value="<?= htmlspecialchars((string) setting('og_title_' . $lang)) ?>">
      </div>
    </div>

    <div class="setting-item">
      <div class="setting-info">
        <strong>Open Graph Description (<?= strtoupper($lang) ?>)</strong>
        <p>This appears when your site is shared on social platforms.</p>
        <input type="text" class="setting-input"
               name="settings[og_description_<?= $lang ?>]"
               data-setting-name="og_description_<?= $lang ?>"
               value="<?= htmlspecialchars((string) setting('og_description_' . $lang)) ?>">
      </div>
    </div>

    <div class="setting-item">
      <div class="setting-info">
        <strong>Twitter Card Title (<?= strtoupper($lang) ?>)</strong>
        <p>Displayed when your site is shared on Twitter.</p>
        <input type="text" class="setting-input"
               name="settings[twitter_title_<?= $lang ?>]"
               data-setting-name="twitter_title_<?= $lang ?>"
               value="<?= htmlspecialchars((string) setting('twitter_title_' . $lang)) ?>">
      </div>
    </div>

    <div class="setting-item">
      <div class="setting-info">
        <strong>Twitter Card Description (<?= strtoupper($lang) ?>)</strong>
        <p>Short summary for Twitter card preview.</p>
        <input type="text" class="setting-input"
               name="settings[twitter_description_<?= $lang ?>]"
               data-setting-name="twitter_description_<?= $lang ?>"
               value="<?= htmlspecialchars((string) setting('twitter_description_' . $lang)) ?>">
      </div>
    </div>
  </div>
<?php endforeach; ?>

<div class="setting-card">
  <div class="setting-item">
    <div class="setting-info">
      <strong>Robots Meta Tag</strong>
      <p>Set instructions for search engine indexing.</p>
      <select class="setting-select" name="settings[robots]" data-setting-name="robots">
        <?php
        $options = [
          'index, follow' => 'Index, Follow (Recommended)',
          'noindex, follow' => 'No Index, Follow',
          'index, nofollow' => 'Index, No Follow',
          'noindex, nofollow' => 'No Index, No Follow',
        ];
        foreach ($options as $val => $label):
        ?>
          <option value="<?= $val ?>" <?= setting('robots') === $val ? 'selected' : '' ?>><?= $label ?></option>
        <?php endforeach; ?>
      </select>
    </div>
  </div>
</div>

<div class="setting-card">
  <div class="setting-item">
    <div class="setting-info">
      <strong>Structured Data (JSON-LD)</strong>
      <p>Add schema markup for better SEO and search visibility.</p>
      <textarea class="setting-textarea"
                name="settings[jsonld]"
                data-setting-name="jsonld"
                rows="12"><?= setting('jsonld') ?></textarea>
    </div>
  </div>
</div>