<?php $_SESSION['tokenMuaf'] = true; ?>

<div class="box-">
  <h1>Outdoor Settings</h1>
</div>

<div class="clear" style="height: 10px;"></div>

<div id="setting-response" style="margin-bottom: 15px;"></div>

<!-- Enable Multi Language -->
<div class="setting-card">
  <div class="setting-item">
    <div class="setting-toggle-wrapper">
      <label class="switch">
        <input type="checkbox" class="setting-toggle" data-setting-name="outdoor_active" <?= setting('outdoor_active') == 1 ? 'checked' : '' ?>>
        <span class="slider"></span>
      </label>
    </div>
    <div class="setting-info">
      <strong>Outdoor Active</strong>
      <p>Change website login system to outdoor instead of insite login pages.</p>
    </div>
  </div>
</div>


<div class="setting-card">
    <div class="setting-item">
        <div class="setting-info">
            <strong>Outdoor Image URL</strong>
            <p>Enter the image URL or upload an image.</p>
            <input type="text" name="settings[outdoor_image]" data-setting-name="outdoor_image" value="<?= setting('outdoor_image') ?>" class="setting-input" placeholder="https://...">
            <input type="file" class="setting-upload" data-upload-type="outdoor_image">
            <div id="preview-outdoor_image" style="margin-top:8px;">
            <?php if (setting('outdoor_image')): ?>
                <img src="<?= setting('outdoor_image') ?>" alt="outdoor_image" style="max-height: 40px; border:1px solid #ccc; padding:4px;">
            <?php endif; ?>
            </div>
        </div>
    </div>
    <div class="setting-item">
        <div class="setting-info">
            <strong>Overlay Opacity</strong>
            <p>Adjust the darkness level above the background image (0 = transparent, 1 = black).</p>
            <input type="number" step="0.01" min="0" max="1" name="settings[outdoor_overlay_opacity]" data-setting-name="outdoor_overlay_opacity" value="<?= setting('outdoor_overlay_opacity', 0.5) ?>" class="setting-input">
        </div>
    </div>
    <div class="setting-item">
        <div class="setting-info">
            <strong>Outdoor Title</strong>
            <p>This will appear in top menu and contact pages.</p>
            <input type="text" name="settings[outdoor_title]" data-setting-name="outdoor_title" value="<?= setting('outdoor_title') ?>" class="setting-input">
        </div>
    </div>
    <div class="setting-item">
        <div class="setting-info">
            <strong>Outdoor Announcement</strong>
            <p>Custom message shown to users when they visit login/signup/forget pages.</p>
            <textarea name="settings[outdoor_description]" data-setting-name="outdoor_description" class="setting-textarea"><?= setting('outdoor_description') ?></textarea>
        </div>
    </div>
</div>

<script>
function showMessage(type, message) {
  const responseBox = document.getElementById('setting-response');
  if (!responseBox) return;

  const className = type === 'success' ? 'alert-success' : 'alert-danger';
  responseBox.innerHTML = `<div class="alert ${className}">${message}</div>`;
}

const saveSetting = (name, value) => {
  fetch('<?= admin_url('ajax/save-setting') ?>', {
    method: 'POST',
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    body: `setting=${encodeURIComponent(name)}&value=${encodeURIComponent(value)}`
  });
}

document.addEventListener('DOMContentLoaded', function () {
  // ✅ Upload inputlarını dinle
  document.querySelectorAll('.setting-upload').forEach(input => {
    input.addEventListener('change', () => {
      const file = input.files[0];
      if (!file) return;

      const formData = new FormData();
      formData.append('upload_type', input.dataset.uploadType);
      formData.append('file', file);

      fetch('<?= admin_url('ajax/upload-setting-image') ?>', {
        method: 'POST',
        body: formData
      })
      .then(res => res.json())
      .then(res => {
        if (res.success) {
          showMessage('success', 'Upload successful.');

          const relatedInput = document.querySelector(`[data-setting-name="${input.dataset.uploadType}"]`);
          if (relatedInput) {
            relatedInput.value = res.url;

            const previewTarget = document.getElementById('preview-' + input.dataset.uploadType);
            if (previewTarget) {
              previewTarget.innerHTML = `<img src="${res.url}?v=${Date.now()}" alt="${input.dataset.uploadType}" style="max-height: 40px; border:1px solid #ccc; padding:4px;">`;
            }
          }

          saveSetting(input.dataset.uploadType, res.url);

        } else {
          showMessage('error', res.message || 'Upload failed.');
        }
      })
      .catch(() => {
        showMessage('error', 'Upload error.');
      });
    });
  });
});
</script>