<?php $_SESSION['tokenMuaf'] = true; ?>

<div class="box-">
  <h1>Menus</h1>
</div>

<div class="clear" style="height: 10px;"></div>

<div id="setting-response" style="margin-bottom: 15px;"></div>

<?php
// slug olusturmak icin hazir fonksiyonu kullan: permalink()

// Menüleri veritabanından çek (örnek amaçlı)
$menus = $Veri->from('app_settings')->where('setting_key LIKE :key')->selectAll(['key' => 'menu_%']);
?>

<div class="admin-tab">
  <div class="tab-container">

    <div class="setting-item">
      <label>Menü Seç</label>
      <select id="menu-select">
        <option value="">Menü Seçin</option>
        <?php foreach ($menus as $menu): 
          $key = $menu['setting_key'];
        ?>
          <option value="<?=$key?>"><?=ucwords(str_replace('menu_', '', $key))?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="setting-item">
      <button type="button" id="new-menu-trigger">+ Yeni Menü Oluştur</button>
    </div>

    <div class="setting-item" id="menu-name-wrapper" style="display:none;">
      <label>Yeni Menü İsmi</label>
      <input type="text" id="new-menu-name" placeholder="Menü İsmi (ör. Kurumsal)">
    </div>

    <div id="menus-container" style="margin-top: 20px; padding: 15px; border: 1px solid #ccc; border-radius: 6px; background: #f9f9f9; display: none;">
      <!-- Aktif düzenleme formu burada oluşturulacak -->
    </div>

    <div class="setting-item">
      <button id="save-menus-btn">Menüyü Kaydet</button>
    </div>

  </div>
</div>

<script>
const allMenus = <?=json_encode($menus)?>;
let editingKey = '';

function renderMenuEditor(key = '', name = '', items = []) {
  const container = document.getElementById('menus-container');
  container.innerHTML = '';

  const wrapper = document.createElement('div');
  wrapper.classList.add('setting-item');
  wrapper.setAttribute('data-key', key);
  wrapper.style.padding = '10px';
  wrapper.style.border = '1px dashed #ccc';
  wrapper.style.marginBottom = '10px';
  wrapper.style.backgroundColor = '#fff';

  const title = key ? `${name} Menüsü` : 'Yeni Menü';
  wrapper.innerHTML = `<label style="font-weight: bold; margin-bottom: 10px; display: block;">${title}</label>
    <div class="menu-items" data-items="${key}" style="display: flex; flex-direction: column; gap: 10px;"></div>
    <div style="margin-top: 10px;">
      <button type="button" class="add-item-btn" data-target="${key}" style="padding: 6px 12px; background: #007bff; color: #fff; border: none; border-radius: 4px;">+ Alt Menü Ekle</button>
    </div>`;

  container.appendChild(wrapper);

  const itemsDiv = wrapper.querySelector('.menu-items');
  items.forEach(obj => {
    const div = document.createElement('div');
    div.classList.add('menu-item-input');
    div.style.cssText = 'margin-bottom: 10px; padding: 8px; border: 1px solid #ccc; border-radius: 4px; background: #fff; display: flex; gap: 10px; align-items: center;';
    div.innerHTML = `
      <label style="flex: 1;">
        <span style="display:block; font-size: 12px; color: #555;">Başlık</span>
        <input type="text" placeholder="Başlık" style="width: 100%;" value="${obj.title}" />
      </label>
      <label style="flex: 2;">
        <span style="display:block; font-size: 12px; color: #555;">URL</span>
        <input type="text" placeholder="URL" style="width: 100%;" value="${obj.url}" />
      </label>
      <button type="button" class="delete-item-btn" style="background: #dc3545; color: #fff; border: none; padding: 5px 10px; border-radius: 3px; cursor: pointer;">×</button>
    `;
    itemsDiv.appendChild(div);
  });

  if (key) {
    const deleteBtn = document.createElement('button');
    deleteBtn.textContent = 'Menüyü Sil';
    deleteBtn.type = 'button';
    deleteBtn.className = 'delete-menu-btn';
    deleteBtn.style = 'margin-top: 10px; background: #d9534f; color: #fff; border: none; padding: 6px 10px; cursor: pointer;';
    deleteBtn.setAttribute('data-key', key);
    wrapper.appendChild(deleteBtn);
  }
}

document.getElementById('menu-select').addEventListener('change', function () {
  const selected = this.value;
  editingKey = selected;
  document.getElementById('new-menu-name').value = '';
  document.getElementById('menu-name-wrapper').style.display = selected ? 'none' : 'block';

  const container = document.getElementById('menus-container');
  container.style.display = 'block';

  if (!selected) {
    renderMenuEditor('', '', []);
    return;
  }

  const selectedMenu = allMenus.find(m => m.setting_key === selected);
  const items = JSON.parse(selectedMenu.setting_value || '[]');
  const name = selected.replace('menu_', '').replace(/-/g, ' ');
  renderMenuEditor(selected, name, items);
});

document.getElementById('new-menu-trigger').addEventListener('click', function () {
  document.getElementById('menu-select').value = '';
  document.getElementById('menu-name-wrapper').style.display = 'block';
  document.getElementById('menus-container').style.display = 'block';
  renderMenuEditor('', '', []);
});

document.addEventListener('click', function (e) {
  if (e.target.classList.contains('add-item-btn')) {
    const target = e.target.getAttribute('data-target');
    const container = document.querySelector(`[data-items="${target}"]`);

    const div = document.createElement('div');
    div.classList.add('menu-item-input');
    div.style.cssText = 'margin-bottom: 10px; padding: 8px; border: 1px solid #ccc; border-radius: 4px; background: #fff; display: flex; gap: 10px; align-items: center;';
    div.innerHTML = `
      <label style="flex: 1;">
        <span style="display:block; font-size: 12px; color: #555;">Başlık</span>
        <input type="text" placeholder="Başlık" style="width: 100%;" />
      </label>
      <label style="flex: 2;">
        <span style="display:block; font-size: 12px; color: #555;">URL</span>
        <input type="text" placeholder="URL" style="width: 100%;" />
      </label>
    `;
    container.appendChild(div);
  }

  if (e.target.classList.contains('delete-item-btn')) {
    e.target.parentNode.remove();
  }

  if (e.target.classList.contains('delete-menu-btn')) {
    const key = e.target.getAttribute('data-key');
    if (!key) {
      alert('Silinecek menü bulunamadı.');
      return;
    }

    if (!confirm('Bu menüyü silmek istediğinizden emin misiniz?')) return;

    console.log("Menü siliniyor:", key);

    fetch('<?=admin_url("ajax/delete-menu")?>', {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
        'Accept': 'application/json'
      },
      body: JSON.stringify({ key: key })
    })
    .then(res => {
      if (!res.ok) throw new Error('Sunucu hatası');
      return res.json();
    })
    .then(res => {
      console.log("Sunucudan cevap:", res);
      if (res.success) {
        alert('Menü başarıyla silindi!');
        location.reload();
      } else {
        alert('Silme işlemi başarısız: ' + (res.error || 'Bilinmeyen hata'));
      }
    })
    .catch(err => {
      console.error("Silme isteği hatası:", err);
      alert('Sunucuya bağlanırken hata oluştu.');
    });
  }
});

document.getElementById('save-menus-btn').addEventListener('click', function () {
  const wrapper = document.querySelector('#menus-container .setting-item');
  if (!wrapper) return;

  let key = wrapper.getAttribute('data-key');
  if (!key) {
    const name = document.getElementById('new-menu-name').value.trim();
    if (!name) return alert('Yeni menü ismi girin');
    key = 'menu_' + name.toLowerCase().replace(/[^a-z0-9]+/g, '-');
  }

  const inputs = wrapper.querySelectorAll('.menu-item-input');
  const lines = Array.from(inputs).map(input => {
    const [titleInput, urlInput] = input.querySelectorAll('input');
    return {
      title: titleInput.value.trim(),
      url: urlInput.value.trim() || '#'
    };
  }).filter(m => m.title !== '');

  fetch('<?=admin_url("ajax/save-menus")?>', {
    method: 'POST',
    headers: { 'Content-Type': 'application/json' },
    body: JSON.stringify({ menus: [{ key, value: JSON.stringify(lines) }] })
  })
  .then(r => r.json())
  .then(res => {
    if (res.success) {
      alert('Menü kaydedildi!');
      location.reload();
    } else {
      alert('Hata oluştu.');
    }
  });
});
</script>